/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public class ArcRecyclingChecker {
    private final Object2BooleanMap<Item> knownItemValidity = new Object2BooleanOpenHashMap();
    private static final Set<RecipeType<?>> RECYCLING_RECIPE_TYPES = new HashSet();
    private static final List<BiPredicate<TagContainer, ItemStack>> RECYCLING_ALLOWED_STACK_SENSITIVE = new ArrayList<BiPredicate<TagContainer, ItemStack>>();
    private static final List<BiPredicate<TagContainer, Item>> RECYCLING_ALLOWED = new ArrayList<BiPredicate<TagContainer, Item>>();
    private static final List<Function<TagContainer, Stream<Item>>> RECYCLING_ALLOWED_ENUMERATED = new ArrayList<Function<TagContainer, Stream<Item>>>();
    private static final List<BiPredicate<TagContainer, ItemStack>> INVALID_RECYCLING_OUTPUTS = new ArrayList<BiPredicate<TagContainer, ItemStack>>();

    public ArcRecyclingChecker(TagContainer tags) {
        RECYCLING_ALLOWED_ENUMERATED.stream().flatMap(f -> (Stream)f.apply(tags)).forEach(i -> this.knownItemValidity.put(i, true));
    }

    public boolean isAllowed(TagContainer tags, ItemStack stack) {
        if (this.knownItemValidity.computeBooleanIfAbsent((Object)stack.m_41720_(), i -> RECYCLING_ALLOWED.stream().anyMatch(p -> p.test(tags, i)))) {
            return true;
        }
        for (BiPredicate<TagContainer, ItemStack> stackSensitive : RECYCLING_ALLOWED_STACK_SENSITIVE) {
            if (!stackSensitive.test(tags, stack)) continue;
            return true;
        }
        return false;
    }

    public static void allowEnumeratedItemsForRecycling(Function<TagContainer, Stream<Item>> getAllowedItems) {
        RECYCLING_ALLOWED_ENUMERATED.add(getAllowedItems);
    }

    public static void allowEnumeratedItemsForRecycling(Supplier<Stream<Item>> getAllowedItems) {
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling((TagContainer $) -> (Stream)getAllowedItems.get());
    }

    public static void allowPrefixedTagForRecycling(String prefix) {
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling((TagContainer tags) -> tags.m_144452_(Registry.f_122904_).m_5643_().entrySet().stream().filter(e -> ((ResourceLocation)e.getKey()).m_135815_().startsWith(prefix)).map(Map.Entry::getValue).flatMap(t -> t.m_6497_().stream()));
    }

    public static void allowItemTagForRecycling(Tag.Named<Item> tag) {
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling((TagContainer tags) -> {
            Tag realTag = tags.m_144452_(Registry.f_122904_).m_13404_(tag.m_6979_());
            return realTag.m_6497_().stream();
        });
    }

    public static void allowSimpleItemForRecycling(BiPredicate<TagContainer, Item> predicate) {
        RECYCLING_ALLOWED.add(predicate);
    }

    public static void allowSimpleItemForRecycling(Predicate<Item> predicate) {
        RECYCLING_ALLOWED.add(($, item) -> predicate.test((Item)item));
    }

    public static void allowRecipeTypeForRecycling(RecipeType<?> recipeType) {
        RECYCLING_RECIPE_TYPES.add(recipeType);
    }

    public static void allowItemForRecycling(BiPredicate<TagContainer, ItemStack> predicate) {
        RECYCLING_ALLOWED_STACK_SENSITIVE.add(predicate);
    }

    public static void makeItemInvalidRecyclingOutput(BiPredicate<TagContainer, ItemStack> predicate) {
        INVALID_RECYCLING_OUTPUTS.add(predicate);
    }

    public static void makeItemInvalidRecyclingOutput(Predicate<ItemStack> predicate) {
        INVALID_RECYCLING_OUTPUTS.add(($, stack) -> predicate.test((ItemStack)stack));
    }

    public static Pair<Predicate<Recipe<?>>, ArcRecyclingChecker> assembleRecyclingFilter(TagContainer tags) {
        ArcRecyclingChecker checker = new ArcRecyclingChecker(tags);
        return Pair.of(iRecipe -> {
            if (!RECYCLING_RECIPE_TYPES.contains(iRecipe.m_6671_())) {
                return false;
            }
            return checker.isAllowed(tags, iRecipe.m_8043_());
        }, (Object)checker);
    }

    public static boolean isValidRecyclingOutput(TagContainer tags, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (BiPredicate<TagContainer, ItemStack> predicate : INVALID_RECYCLING_OUTPUTS) {
            if (!predicate.test(tags, stack)) continue;
            return false;
        }
        return true;
    }
}

