/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class ArcFurnaceRecipe
extends MultiblockRecipe {
    public static RecipeType<ArcFurnaceRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<ArcFurnaceRecipe>> SERIALIZER;
    public final IngredientWithSize input;
    public final IngredientWithSize[] additives;
    public final NonNullList<ItemStack> output;
    public final List<StackWithChance> secondaryOutputs;
    @Nonnull
    public final ItemStack slag;
    public String specialRecipeType;
    public static List<String> specialRecipeTypes;
    public static Map<ResourceLocation, ArcFurnaceRecipe> recipeList;

    public ArcFurnaceRecipe(ResourceLocation id, NonNullList<ItemStack> output, @Nonnull ItemStack slag, List<StackWithChance> secondaryOutputs, int time, int energy, IngredientWithSize input, IngredientWithSize ... additives) {
        super((ItemStack)output.get(0), TYPE, id);
        this.output = output;
        this.secondaryOutputs = secondaryOutputs;
        this.input = input;
        this.slag = slag;
        this.setTimeAndEnergy(time, energy);
        this.additives = additives;
        ArrayList inputList = Lists.newArrayList((Object[])new IngredientWithSize[]{this.input});
        if (this.additives.length > 0) {
            inputList.addAll(Lists.newArrayList((Object[])this.additives));
        }
        this.setInputListWithSizes(inputList);
        this.outputList = this.output;
    }

    protected IERecipeSerializer<ArcFurnaceRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    public NonNullList<ItemStack> getBaseOutputs() {
        return this.output;
    }

    public NonNullList<ItemStack> generateActualOutput(ItemStack input, NonNullList<ItemStack> additives, long seed) {
        Random random = new Random(seed);
        NonNullList actualOutput = NonNullList.m_122780_((int)this.output.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.output.size(); ++i) {
            actualOutput.set(i, (Object)((ItemStack)this.output.get(i)).m_41777_());
        }
        for (StackWithChance secondary : this.secondaryOutputs) {
            if (secondary.chance() > random.nextFloat()) continue;
            ItemStack remaining = secondary.stack();
            for (ItemStack existing : actualOutput) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)remaining, (ItemStack)existing)) continue;
                existing.m_41769_(remaining.m_41613_());
                remaining = ItemStack.f_41583_;
                break;
            }
            if (remaining.m_41619_()) continue;
            actualOutput.add((Object)remaining);
        }
        return actualOutput;
    }

    public boolean matches(ItemStack input, NonNullList<ItemStack> additives) {
        if (this.input != null && this.input.test(input)) {
            int[] consumed = this.getConsumedAdditives(additives, false);
            return consumed != null;
        }
        return false;
    }

    public int[] getConsumedAdditives(NonNullList<ItemStack> additives, boolean consume) {
        int[] consumed = new int[additives.size()];
        for (IngredientWithSize add : this.additives) {
            if (add == null) continue;
            int addAmount = add.getCount();
            Iterator it = additives.iterator();
            int i = 0;
            while (it.hasNext()) {
                ItemStack query = (ItemStack)it.next();
                if (!query.m_41619_()) {
                    if (add.test(query)) {
                        if (query.m_41613_() > addAmount) {
                            query.m_41774_(addAmount);
                            consumed[i] = addAmount;
                            addAmount = 0;
                        } else {
                            addAmount -= query.m_41613_();
                            consumed[i] = query.m_41613_();
                            query.m_41764_(0);
                        }
                    }
                    if (addAmount <= 0) break;
                }
                ++i;
            }
            if (addAmount <= 0) continue;
            for (int j = 0; j < consumed.length; ++j) {
                ((ItemStack)additives.get(j)).m_41769_(consumed[j]);
            }
            return null;
        }
        if (!consume) {
            for (int j = 0; j < consumed.length; ++j) {
                ((ItemStack)additives.get(j)).m_41769_(consumed[j]);
            }
        }
        return consumed;
    }

    public boolean isValidInput(ItemStack stack) {
        return this.input != null && this.input.test(stack);
    }

    public boolean isValidAdditive(ItemStack stack) {
        for (IngredientWithSize add : this.additives) {
            if (add == null || !add.test(stack)) continue;
            return true;
        }
        return false;
    }

    public ArcFurnaceRecipe setSpecialRecipeType(String type) {
        this.specialRecipeType = type;
        if (!specialRecipeTypes.contains(type)) {
            specialRecipeTypes.add(type);
        }
        return this;
    }

    public static ArcFurnaceRecipe findRecipe(ItemStack input, NonNullList<ItemStack> additives) {
        for (ArcFurnaceRecipe recipe : recipeList.values()) {
            if (recipe == null || !recipe.matches(input, additives)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidRecipeInput(ItemStack stack) {
        for (ArcFurnaceRecipe recipe : recipeList.values()) {
            if (recipe == null || !recipe.isValidInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidRecipeAdditive(ItemStack stack) {
        for (ArcFurnaceRecipe recipe : recipeList.values()) {
            if (recipe == null || !recipe.isValidAdditive(stack)) continue;
            return true;
        }
        return false;
    }

    static {
        specialRecipeTypes = new ArrayList<String>();
        recipeList = Collections.emptyMap();
    }
}

