/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StaticTagHelper;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class IETags {
    private static final Map<Tag.Named<Block>, Tag.Named<Item>> toItemTag = new HashMap<Tag.Named<Block>, Tag.Named<Item>>();
    private static final Map<EnumMetals, MetalTags> metals = new HashMap<EnumMetals, MetalTags>();
    public static final Tag.Named<Item> clay = TagUtils.createItemWrapper(IETags.forgeLoc("clay"));
    public static final Tag.Named<Block> clayBlock = IETags.createBlockTag(IETags.getStorageBlock("clay"));
    public static final Tag.Named<Item> charCoal = TagUtils.createItemWrapper(IETags.forgeLoc("charcoal"));
    public static final Tag.Named<Block> glowstoneBlock = IETags.createBlockTag(IETags.getStorageBlock("glowstone"));
    public static final Tag.Named<Block> colorlessSandstoneBlocks = IETags.createBlockTag(IETags.forgeLoc("sandstone/colorless"));
    public static final Tag.Named<Block> redSandstoneBlocks = IETags.createBlockTag(IETags.forgeLoc("sandstone/red"));
    public static final Tag.Named<Block> treatedWood = IETags.createBlockTag(IETags.forgeLoc("treated_wood"));
    public static final Tag.Named<Block> treatedWoodSlab = IETags.createBlockTag(IETags.forgeLoc("treated_wood_slab"));
    public static final Tag.Named<Block> coalCokeBlock = IETags.createBlockTag(IETags.getStorageBlock("coal_coke"));
    public static final Tag.Named<Block> scaffoldingSteel = IETags.createBlockTag(IETags.rl("scaffoldings/steel"));
    public static final Tag.Named<Block> scaffoldingAlu = IETags.createBlockTag(IETags.rl("scaffoldings/aluminum"));
    public static final Tag.Named<Block> sheetmetals = IETags.createBlockTag(IETags.forgeLoc("sheetmetals"));
    public static final Tag.Named<Block> fencesSteel = IETags.createBlockTag(IETags.forgeLoc("fences/steel"));
    public static final Tag.Named<Block> fencesAlu = IETags.createBlockTag(IETags.forgeLoc("fences/aluminum"));
    public static final Tag.Named<Item> treatedStick = TagUtils.createItemWrapper(IETags.getRod("treated_wood"));
    public static final Tag.Named<Item> ironRod = TagUtils.createItemWrapper(IETags.getRod("iron"));
    public static final Tag.Named<Item> steelRod = TagUtils.createItemWrapper(IETags.getRod("steel"));
    public static final Tag.Named<Item> metalRods = TagUtils.createItemWrapper(IETags.getRod("all_metal"));
    public static final Tag.Named<Item> aluminumRod = TagUtils.createItemWrapper(IETags.getRod("aluminum"));
    public static final Tag.Named<Item> fiberHemp = TagUtils.createItemWrapper(IETags.forgeLoc("fiber_hemp"));
    public static final Tag.Named<Item> fabricHemp = TagUtils.createItemWrapper(IETags.forgeLoc("fabric_hemp"));
    public static final Tag.Named<Item> coalCoke = TagUtils.createItemWrapper(IETags.forgeLoc("coal_coke"));
    public static final Tag.Named<Item> slag = TagUtils.createItemWrapper(IETags.forgeLoc("slag"));
    public static final Tag.Named<Item> coalCokeDust = TagUtils.createItemWrapper(IETags.getDust("coal_coke"));
    public static final Tag.Named<Item> hopGraphiteDust = TagUtils.createItemWrapper(IETags.getDust("hop_graphite"));
    public static final Tag.Named<Item> hopGraphiteIngot = TagUtils.createItemWrapper(IETags.getIngot("hop_graphite"));
    public static final Tag.Named<Item> copperWire = TagUtils.createItemWrapper(IETags.getWire("copper"));
    public static final Tag.Named<Item> electrumWire = TagUtils.createItemWrapper(IETags.getWire("electrum"));
    public static final Tag.Named<Item> aluminumWire = TagUtils.createItemWrapper(IETags.getWire("aluminum"));
    public static final Tag.Named<Item> steelWire = TagUtils.createItemWrapper(IETags.getWire("steel"));
    public static final Tag.Named<Item> leadWire = TagUtils.createItemWrapper(IETags.getWire("lead"));
    public static final Tag.Named<Item> allWires = TagUtils.createItemWrapper(IETags.forgeLoc("wires"));
    public static final Tag.Named<Item> saltpeterDust = TagUtils.createItemWrapper(IETags.getDust("saltpeter"));
    public static final Tag.Named<Item> sulfurDust = TagUtils.createItemWrapper(IETags.getDust("sulfur"));
    public static final Tag.Named<Item> sawdust = TagUtils.createItemWrapper(IETags.getDust("wood"));
    public static final Tag.Named<Item> plates = TagUtils.createItemWrapper(IETags.forgeLoc("plates"));
    public static final Tag.Named<Item> sawblades = TagUtils.createItemWrapper(IETags.forgeLoc("sawblades"));
    public static final Tag.Named<Item> forbiddenInCrates = TagUtils.createItemWrapper(IETags.rl("forbidden_in_crates"));
    public static final Tag.Named<Item> circuitPCB = TagUtils.createItemWrapper(IETags.rl("circuits/pcb"));
    public static final Tag.Named<Item> circuitLogic = TagUtils.createItemWrapper(IETags.rl("circuits/logic"));
    public static final Tag.Named<Item> circuitSolder = TagUtils.createItemWrapper(IETags.rl("circuits/solder"));
    public static final Tag.Named<Item> hammers = TagUtils.createItemWrapper(IETags.rl("tools/hammers"));
    public static final Tag.Named<Item> screwdrivers = TagUtils.createItemWrapper(IETags.rl("tools/screwdrivers"));
    public static final Tag.Named<Item> wirecutters = TagUtils.createItemWrapper(IETags.rl("tools/wirecutters"));
    public static final Tag.Named<Item> toolboxTools = TagUtils.createItemWrapper(IETags.rl("toolbox/tools"));
    public static final Tag.Named<Item> toolboxFood = StaticTagHelper.createDelayedOptional((ResourceLocation)ForgeRegistries.ITEMS.getRegistryName(), (ResourceLocation)IETags.rl("toolbox/food"), null);
    public static final Tag.Named<Item> toolboxWiring = TagUtils.createItemWrapper(IETags.rl("toolbox/wiring"));
    public static final Tag.Named<Block> hammerHarvestable = TagUtils.createBlockWrapper(IETags.rl("mineable/hammer"));
    public static final Tag.Named<Block> wirecutterHarvestable = TagUtils.createBlockWrapper(IETags.rl("mineable/wirecutter"));
    public static final Tag.Named<Block> drillHarvestable = TagUtils.createBlockWrapper(IETags.rl("mineable/drill"));
    public static final Tag.Named<Fluid> fluidCreosote = TagUtils.createFluidWrapper(IETags.forgeLoc("creosote"));
    public static final Tag.Named<Fluid> fluidPlantoil = TagUtils.createFluidWrapper(IETags.forgeLoc("plantoil"));
    public static final Tag.Named<Fluid> fluidEthanol = TagUtils.createFluidWrapper(IETags.forgeLoc("ethanol"));
    public static final Tag.Named<Fluid> fluidBiodiesel = TagUtils.createFluidWrapper(IETags.forgeLoc("biodiesel"));
    public static final Tag.Named<Fluid> fluidConcrete = TagUtils.createFluidWrapper(IETags.forgeLoc("concrete"));
    public static final Tag.Named<Fluid> fluidHerbicide = TagUtils.createFluidWrapper(IETags.forgeLoc("herbicide"));
    public static final Tag.Named<Fluid> fluidRedstoneAcid = TagUtils.createFluidWrapper(IETags.forgeLoc("redstone_acid"));
    public static final Tag.Named<Fluid> fluidPotion = TagUtils.createFluidWrapper(IETags.forgeLoc("potion"));
    public static final Tag.Named<Fluid> drillFuel = TagUtils.createFluidWrapper(IETags.rl("drill_fuel"));

    public static Tag.Named<Item> getItemTag(Tag.Named<Block> blockTag) {
        Preconditions.checkArgument((boolean)toItemTag.containsKey(blockTag));
        return toItemTag.get(blockTag);
    }

    public static MetalTags getTagsFor(EnumMetals metal) {
        return metals.get((Object)metal);
    }

    private static Tag.Named<Block> createBlockTag(ResourceLocation name) {
        Tag.Named<Block> blockTag = TagUtils.createBlockWrapper(name);
        toItemTag.put(blockTag, TagUtils.createItemWrapper(name));
        return blockTag;
    }

    public static void forAllBlocktags(BiConsumer<Tag.Named<Block>, Tag.Named<Item>> out) {
        for (Map.Entry<Tag.Named<Block>, Tag.Named<Item>> entry : toItemTag.entrySet()) {
            out.accept(entry.getKey(), entry.getValue());
        }
    }

    private static ResourceLocation forgeLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    public static ResourceLocation getOre(String type) {
        return IETags.forgeLoc("ores/" + type);
    }

    public static ResourceLocation getRawOre(String type) {
        return IETags.forgeLoc("raw_ores/" + type);
    }

    public static ResourceLocation getNugget(String type) {
        return IETags.forgeLoc("nuggets/" + type);
    }

    public static ResourceLocation getIngot(String type) {
        return IETags.forgeLoc("ingots/" + type);
    }

    public static ResourceLocation getGem(String type) {
        return IETags.forgeLoc("gems/" + type);
    }

    public static ResourceLocation getStorageBlock(String type) {
        return IETags.forgeLoc("storage_blocks/" + type);
    }

    public static ResourceLocation getRawBlock(String type) {
        return IETags.forgeLoc("raw_blocks/" + type);
    }

    public static ResourceLocation getDust(String type) {
        return IETags.forgeLoc("dusts/" + type);
    }

    public static ResourceLocation getPlate(String type) {
        return IETags.forgeLoc("plates/" + type);
    }

    public static ResourceLocation getRod(String type) {
        return IETags.forgeLoc("rods/" + type);
    }

    public static ResourceLocation getGear(String type) {
        return IETags.forgeLoc("gears/" + type);
    }

    public static ResourceLocation getWire(String type) {
        return IETags.forgeLoc("wires/" + type);
    }

    public static ResourceLocation getSheetmetalBlock(String type) {
        return IETags.forgeLoc("sheetmetals/" + type);
    }

    private static ResourceLocation rl(String path) {
        return new ResourceLocation("immersiveengineering", path);
    }

    static {
        for (EnumMetals m : EnumMetals.values()) {
            metals.put(m, new MetalTags(m));
        }
    }

    public static class MetalTags {
        public final Tag.Named<Item> ingot;
        public final Tag.Named<Item> nugget;
        @Nullable
        public final Tag.Named<Item> rawOre;
        public final Tag.Named<Item> plate;
        public final Tag.Named<Item> dust;
        public final Tag.Named<Block> storage;
        public final Tag.Named<Block> sheetmetal;
        @Nullable
        public final Tag.Named<Block> ore;
        @Nullable
        public final Tag.Named<Block> rawBlock;

        private MetalTags(EnumMetals m) {
            String name = m.tagName();
            Tags.IOptionalNamedTag ore = null;
            Tag.Named<Item> rawOre = null;
            Tag.Named<Block> rawBlock = null;
            if (m.shouldAddOre()) {
                ore = IETags.createBlockTag(IETags.getOre(name));
                rawOre = TagUtils.createItemWrapper(IETags.getRawOre(name));
                rawBlock = IETags.createBlockTag(IETags.getRawBlock(name));
            }
            if (!m.isVanillaMetal()) {
                this.storage = IETags.createBlockTag(IETags.getStorageBlock(name));
            } else if (m == EnumMetals.COPPER) {
                this.storage = IETags.createBlockTag(IETags.getStorageBlock(name));
                ore = IETags.createBlockTag(IETags.getOre(name));
                rawBlock = IETags.createBlockTag(IETags.getRawBlock(name));
            } else if (m == EnumMetals.IRON) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_IRON;
                ore = Tags.Blocks.ORES_IRON;
                rawBlock = IETags.createBlockTag(IETags.getRawBlock(name));
            } else if (m == EnumMetals.GOLD) {
                this.storage = Tags.Blocks.STORAGE_BLOCKS_GOLD;
                ore = Tags.Blocks.ORES_GOLD;
                rawBlock = IETags.createBlockTag(IETags.getRawBlock(name));
            } else {
                throw new RuntimeException("Unkown vanilla metal: " + m.name());
            }
            this.sheetmetal = IETags.createBlockTag(IETags.getSheetmetalBlock(name));
            this.nugget = TagUtils.createItemWrapper(IETags.getNugget(name));
            this.ingot = TagUtils.createItemWrapper(IETags.getIngot(name));
            this.plate = TagUtils.createItemWrapper(IETags.getPlate(name));
            this.dust = TagUtils.createItemWrapper(IETags.getDust(name));
            this.ore = ore;
            this.rawOre = rawOre;
            this.rawBlock = rawBlock;
        }
    }
}

