/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class RegistryUtils {
    private static final List<DeferredRegister<?>> ENTRIES = new ArrayList();
    private static Phase phase = Phase.PRE_INIT;
    private static String modId;

    public static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> create(Class<T> type) {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        DeferredRegister entry = DeferredRegister.create(type, (String)modId);
        ENTRIES.add(entry);
        return entry;
    }

    public static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> create(IForgeRegistry<T> registry) {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        DeferredRegister entry = DeferredRegister.create(registry, (String)modId);
        ENTRIES.add(entry);
        return entry;
    }

    public static void begin(String modId) {
        RegistryUtils.modId = modId;
        if (phase != Phase.PRE_INIT) {
            throw new IllegalStateException();
        }
        phase = Phase.INIT;
    }

    public static void finish() {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        phase = Phase.POST_INIT;
        for (DeferredRegister<?> register : ENTRIES) {
            register.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
        ENTRIES.clear();
    }

    private RegistryUtils() {
    }

    private static enum Phase {
        PRE_INIT,
        INIT,
        POST_INIT;

    }
}

