/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.provider;

import java.util.Optional;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.provider.RendererProvider;
import li.cil.manual.api.render.ContentRenderer;
import li.cil.manual.client.document.Strings;
import li.cil.manual.client.document.segment.render.MissingContentRenderer;
import li.cil.manual.client.document.segment.render.TextureContentRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public final class TextureRendererProvider
extends ForgeRegistryEntry<RendererProvider>
implements RendererProvider {
    private static final String[] EXTENSIONS = new String[]{".png", ".gif", ".jpg", ".jpeg", ".bmp", ".tga"};

    @Override
    public int sortOrder() {
        return 10000;
    }

    @Override
    public boolean matches(ManualModel manual) {
        return true;
    }

    @Override
    public Optional<ContentRenderer> getRenderer(String path) {
        if (!TextureRendererProvider.hasSupportedExtension(path)) {
            return Optional.empty();
        }
        try {
            return Optional.of(new TextureContentRenderer(new ResourceLocation(path)));
        }
        catch (Throwable t) {
            return Optional.of(new MissingContentRenderer(Strings.NO_SUCH_IMAGE));
        }
    }

    private static boolean hasSupportedExtension(String path) {
        for (String extension : EXTENSIONS) {
            if (!path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

