/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.document.segment.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.io.IOException;
import li.cil.manual.api.render.ContentRenderer;
import li.cil.manual.client.document.DocumentRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureContentRenderer
implements ContentRenderer {
    private final ResourceLocation location;
    private final ImageTexture texture;

    public TextureContentRenderer(ResourceLocation location) {
        this.location = location;
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        AbstractTexture image = manager.m_118506_(location);
        if (image instanceof ImageTexture) {
            ImageTexture imageTexture;
            this.texture = imageTexture = (ImageTexture)image;
        } else {
            this.texture = new ImageTexture(location);
            manager.m_118495_(location, (AbstractTexture)this.texture);
            if (!this.texture.isValid) {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public int getWidth() {
        return this.texture.width;
    }

    @Override
    public int getHeight() {
        return this.texture.height;
    }

    @Override
    public void render(PoseStack matrixStack, int mouseX, int mouseY) {
        DocumentRenderTypes.draw(DocumentRenderTypes.texture(this.location), buffer -> {
            Matrix4f matrix = matrixStack.m_85850_().m_85861_();
            buffer.m_85982_(matrix, 0.0f, (float)this.texture.height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_85982_(matrix, (float)this.texture.width, (float)this.texture.height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_85982_(matrix, (float)this.texture.width, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        });
    }

    private static class ImageTexture
    extends SimpleTexture {
        private int width = 0;
        private int height = 0;
        private boolean isValid;

        ImageTexture(ResourceLocation location) {
            super(location);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void m_6704_(ResourceManager manager) throws IOException {
            super.m_6704_(manager);
            try (SimpleTexture.TextureImage textureData = this.m_6335_(manager);){
                NativeImage nativeImage = textureData.m_118158_();
                this.width = nativeImage.m_84982_();
                this.height = nativeImage.m_85084_();
                this.isValid = true;
            }
        }
    }
}

