/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.document.segment;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import li.cil.manual.api.render.FontRenderer;
import li.cil.manual.client.document.DocumentRenderer;
import li.cil.manual.client.document.segment.AbstractSegment;
import li.cil.manual.client.document.segment.InteractiveSegment;
import li.cil.manual.client.document.segment.NextSegmentInfo;
import li.cil.manual.client.document.segment.Segment;
import li.cil.manual.client.document.segment.SegmentRefiner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class TextSegment
extends AbstractSegment {
    private static final char[] BREAKS = new char[]{' ', '.', ',', ':', ';', '!', '?', '_', '=', '-', '+', '*', '/', '\\'};
    private static final CharSequence[] LISTS = new CharSequence[]{"- ", "* "};
    private final String text;
    private final List<TextBlock> blockCache = new ArrayList<TextBlock>();
    private CacheKey blockCacheKey;
    private NextSegmentInfo nextCache;
    private CacheKey nextCacheKey;

    public TextSegment(DocumentRenderer document, @Nullable Segment parent, String text) {
        super(document, parent);
        this.text = text;
    }

    @Override
    public int getLineHeight(int indent, int documentWidth) {
        return this.getLineHeight();
    }

    @Override
    public NextSegmentInfo getNext(int segmentX, int lineHeight, int documentWidth) {
        CacheKey cacheKey = new CacheKey(segmentX, lineHeight, documentWidth);
        if (!Objects.equals(cacheKey, this.nextCacheKey)) {
            this.nextCache = new NextSegmentInfo(this.next);
            this.forEachBlock(segmentX, lineHeight, documentWidth, block -> {
                this.nextCache.absoluteX = block.x + this.getStringWidth(block.chars);
                this.nextCache.relativeY = block.y;
            });
            if (this.next != null && this.next.getLineRoot() != this.getLineRoot()) {
                this.nextCache.absoluteX = 0;
                this.nextCache.relativeY = this.nextCache.relativeY == 0 ? Math.max(lineHeight, this.getLineHeight()) : (this.nextCache.relativeY += this.getLineHeight());
            }
            this.nextCacheKey = cacheKey;
        }
        return this.nextCache;
    }

    @Override
    public Optional<InteractiveSegment> render(PoseStack matrixStack, int segmentX, int lineHeight, int documentWidth, int mouseX, int mouseY) {
        String format = this.getFormat();
        float scale = this.getFontScale() * this.getScale();
        int color = this.getColor();
        Optional<InteractiveSegment> interactive = this.getInteractiveParent();
        ObjectReference hovered = new ObjectReference(Optional.empty());
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)builder);
        this.forEachBlock(segmentX, lineHeight, documentWidth, block -> {
            int blockWidth = this.getStringWidth(block.chars);
            int blockHeight = this.getLineHeight();
            if (((Optional)hovered.value).isEmpty() && mouseX >= block.x && mouseX <= block.x + blockWidth && mouseY >= block.y && mouseY <= block.y + blockHeight) {
                hovered.value = interactive;
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)block.x, (double)block.y, 0.0);
            matrixStack.m_85841_(scale, scale, scale);
            this.getFont().drawBatch(matrixStack, (MultiBufferSource)bufferSource, format + block.chars, color);
            matrixStack.m_85849_();
        });
        bufferSource.m_109911_();
        return (Optional)hovered.value;
    }

    @Override
    public Iterable<Segment> refine(Pattern pattern, SegmentRefiner factory) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        int textStart = 0;
        Matcher matcher = pattern.matcher(this.text);
        while (matcher.find()) {
            if (matcher.start() > textStart) {
                result.add(new TextSegment(this.document, this, this.text.substring(textStart, matcher.start())));
            }
            textStart = matcher.end();
            result.add(factory.refine(this.document, this, matcher));
        }
        if (textStart == 0) {
            result.add(this);
        } else if (textStart < this.text.length()) {
            result.add(new TextSegment(this.document, this, this.text.substring(textStart)));
        }
        return result;
    }

    public String toString() {
        return this.text;
    }

    protected boolean isIgnoringLeadingWhitespace() {
        return true;
    }

    protected FontRenderer getFont() {
        return this.style.getRegularFont();
    }

    protected int getColor() {
        return this.tryGetFromParent(this.style.getRegularTextColor(), TextSegment::getColor);
    }

    protected float getScale() {
        return this.tryGetFromParent(Float.valueOf(1.0f), TextSegment::getScale).floatValue();
    }

    protected String getFormat() {
        return this.tryGetFromParent("", TextSegment::getFormat);
    }

    protected int getLineHeight() {
        return (int)((float)(this.getFont().lineHeight() + 1) * this.getFontScale() * this.getScale());
    }

    private float getFontScale() {
        return (float)this.style.getLineHeight() / (float)this.getFont().lineHeight();
    }

    private int getStringWidth(CharSequence string) {
        return (int)((float)this.getFont().width(this.getFormat() + string) * this.getFontScale() * this.getScale());
    }

    private void forEachBlock(int segmentX, int lineHeight, int documentWidth, Consumer<TextBlock> blockConsumer) {
        CacheKey cacheKey = new CacheKey(segmentX, lineHeight, documentWidth);
        if (!Objects.equals(cacheKey, this.blockCacheKey)) {
            this.blockCache.clear();
            String chars = this.text;
            if (this.isIgnoringLeadingWhitespace() && segmentX == 0) {
                chars = chars.substring(TextSegment.indexOfFirstNonWhitespace(chars));
            }
            int wrappedIndent = this.computeWrappedIndent();
            int currentX = segmentX;
            int currentY = 0;
            int charCount = this.computeCharsFittingOnLine(chars, documentWidth - currentX, documentWidth - wrappedIndent);
            while (chars.length() > 0) {
                String blockChars = chars.substring(0, charCount);
                this.blockCache.add(new TextBlock(currentX, currentY, blockChars));
                currentX = wrappedIndent;
                currentY = currentY == 0 ? Math.max(lineHeight, this.getLineHeight()) : (currentY += this.getLineHeight());
                chars = chars.substring(charCount);
                chars = chars.substring(TextSegment.indexOfFirstNonWhitespace(chars));
                charCount = this.computeCharsFittingOnLine(chars, documentWidth - currentX, documentWidth - wrappedIndent);
            }
            this.blockCacheKey = cacheKey;
        }
        for (TextBlock block : this.blockCache) {
            blockConsumer.accept(block);
        }
    }

    private static int indexOfFirstNonWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return s.length();
    }

    private int computeCharsFittingOnLine(String string, int remainingLineWidth, int documentWidth) {
        int count;
        int fullWidth = this.getStringWidth(string);
        int lastBreak = -1;
        for (count = 0; count < string.length(); ++count) {
            boolean exceedsLineLength;
            int nextLargerWidth = this.getStringWidth(string.substring(0, count + 1));
            boolean bl = exceedsLineLength = nextLargerWidth >= remainingLineWidth;
            if (exceedsLineLength) {
                boolean matchesFullLine;
                boolean mayUseFullLine = remainingLineWidth == documentWidth;
                boolean canFitInLine = fullWidth <= documentWidth;
                boolean bl2 = matchesFullLine = fullWidth == documentWidth;
                if (lastBreak >= 0) {
                    return lastBreak + 1;
                }
                if (mayUseFullLine && matchesFullLine) {
                    return string.length();
                }
                if (canFitInLine && !mayUseFullLine) {
                    return 0;
                }
                return count;
            }
            if (!ArrayUtils.contains((char[])BREAKS, (char)string.charAt(count))) continue;
            lastBreak = count;
        }
        return count;
    }

    private <T> T tryGetFromParent(T defaultValue, Function<TextSegment, T> getter) {
        Object t;
        Optional parent = this.getParent();
        if (parent.isPresent() && (t = parent.get()) instanceof TextSegment) {
            TextSegment textSegment = (TextSegment)t;
            return getter.apply(textSegment);
        }
        return defaultValue;
    }

    private Optional<InteractiveSegment> getInteractiveParent() {
        Optional<Segment> optional = Optional.of(this);
        while (optional.isPresent()) {
            Segment segment = optional.get();
            if (segment instanceof InteractiveSegment) {
                InteractiveSegment interactiveSegment = (InteractiveSegment)segment;
                return Optional.of(interactiveSegment);
            }
            optional = segment.getParent();
        }
        return Optional.empty();
    }

    private TextSegment getRootTextSegment() {
        Object t;
        TextSegment rootSegment = this;
        Optional parent = this.getParent();
        while (parent.isPresent() && (t = parent.get()) instanceof TextSegment) {
            TextSegment textSegment;
            rootSegment = textSegment = (TextSegment)t;
            parent = textSegment.getParent();
        }
        return rootSegment;
    }

    private int computeWrappedIndent() {
        TextSegment textSegment = this.getRootTextSegment();
        CharSequence rootPrefix = textSegment.text.subSequence(0, Math.min(2, textSegment.text.length()));
        return ArrayUtils.contains((Object[])LISTS, (Object)rootPrefix) ? this.getFont().width(rootPrefix) : 0;
    }

    private record CacheKey(int segmentX, int lineHeight, int documentWidth) {
    }

    private static final class ObjectReference<T> {
        public T value;

        public ObjectReference(T value) {
            this.value = value;
        }
    }

    private record TextBlock(int x, int y, String chars) {
    }
}

