/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.client.document.segment;

import java.util.Optional;
import li.cil.manual.client.document.DocumentRenderer;
import li.cil.manual.client.document.segment.InteractiveSegment;
import li.cil.manual.client.document.segment.Segment;
import li.cil.manual.client.document.segment.TextSegment;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class LinkSegment
extends TextSegment
implements InteractiveSegment {
    private static final int FADE_TIME = 500;
    private final String url;
    private final boolean isWebUrl;
    private final boolean isLinkValid;
    private boolean isHovered;
    private long lastHovered = System.currentTimeMillis() - 500L;

    public LinkSegment(DocumentRenderer document, Segment parent, String text, String url) {
        super(document, parent, text);
        this.url = url;
        this.isWebUrl = url.startsWith("http://") || url.startsWith("https://");
        this.isLinkValid = this.isWebUrl || this.model.documentFor(this.model.resolve(url)).isPresent();
    }

    @Override
    public Optional<Component> getTooltip() {
        if (this.style.showLinkTooltip()) {
            return Optional.of(new TextComponent(this.url));
        }
        return Optional.empty();
    }

    @Override
    public boolean mouseClicked() {
        if (this.isWebUrl) {
            Util.m_137581_().m_137646_(this.url);
        } else {
            this.model.push(this.model.resolve(this.url));
        }
        return true;
    }

    @Override
    public void setMouseHovered(boolean value) {
        this.isHovered = value;
        if (!value) {
            this.lastHovered = System.currentTimeMillis();
        }
    }

    @Override
    public String toString() {
        return String.format("[%s](%s)", super.toString(), this.url);
    }

    @Override
    protected int getColor() {
        int timeSinceHover;
        int hoverColor;
        int color;
        if (this.isLinkValid) {
            color = this.style.getRegularLinkColor();
            hoverColor = this.style.getHoveredLinkColor();
        } else {
            color = this.style.getRegularDeadLinkColor();
            hoverColor = this.style.getHoveredDeadLinkColor();
        }
        int n = timeSinceHover = this.isHovered ? 0 : (int)(System.currentTimeMillis() - this.lastHovered);
        if (timeSinceHover <= 500) {
            return LinkSegment.fadeColor(hoverColor, color, (float)timeSinceHover / 500.0f);
        }
        return color;
    }

    @Override
    protected String getFormat() {
        if (this.isHovered) {
            return super.getFormat() + ChatFormatting.UNDERLINE;
        }
        return super.getFormat();
    }

    private static int fadeColor(int color1, int color2, float t) {
        int a1 = color1 >>> 24 & 0xFF;
        int r1 = color1 >>> 16 & 0xFF;
        int g1 = color1 >>> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >>> 24 & 0xFF;
        int r2 = color2 >>> 16 & 0xFF;
        int g2 = color2 >>> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

