/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.api.prefab.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import java.util.Optional;
import li.cil.manual.api.render.FontRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BitmapFontRenderer
implements FontRenderer {
    private final Char2IntMap CHAR_MAP;
    private final int COLUMNS = this.getResolution() / (this.charWidth() + this.getGapU());
    private final float U_SIZE = (float)this.charWidth() / (float)this.getResolution();
    private final float V_SIZE = (float)this.lineHeight() / (float)this.getResolution();
    private final float U_STEP = (float)(this.charWidth() + this.getGapU()) / (float)this.getResolution();
    private final float V_STEP = (float)(this.lineHeight() + this.getGapV()) / (float)this.getResolution();
    private RenderType renderLayer;

    protected BitmapFontRenderer() {
        this.CHAR_MAP = new Char2IntOpenHashMap();
        CharSequence chars = this.getCharacters();
        for (int index = 0; index < chars.length(); ++index) {
            this.CHAR_MAP.put(chars.charAt(index), index);
        }
    }

    @Override
    public void drawBatch(PoseStack matrixStack, MultiBufferSource bufferFactory, CharSequence value, int argb) {
        VertexConsumer buffer = this.getDefaultBuffer(bufferFactory);
        float tx = 0.0f;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            this.drawChar(matrixStack, buffer, argb, tx, ch);
            tx += (float)(this.width(" ") + this.getGapU());
        }
    }

    @Override
    public int width(CharSequence value) {
        return value.length() * this.charWidth();
    }

    @Override
    public int width(Component value) {
        MutableInteger count = new MutableInteger();
        value.m_5651_(s -> {
            count.value += s.length() * this.charWidth();
            return Optional.empty();
        });
        return count.value;
    }

    protected abstract CharSequence getCharacters();

    protected abstract ResourceLocation getTextureLocation();

    protected abstract int getResolution();

    protected abstract int getGapU();

    protected abstract int getGapV();

    protected abstract int charWidth();

    private VertexConsumer getDefaultBuffer(MultiBufferSource bufferFactory) {
        if (this.renderLayer == null) {
            this.renderLayer = FontRenderTypes.create(this.getTextureLocation());
        }
        return bufferFactory.m_6299_(this.renderLayer);
    }

    private void drawChar(PoseStack matrixStack, VertexConsumer buffer, int argb, float x, char ch) {
        if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
            return;
        }
        int index = this.getCharIndex(ch);
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        int column = index % this.COLUMNS;
        int row = index / this.COLUMNS;
        float u = (float)column * this.U_STEP;
        float v = (float)row * this.V_STEP;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        buffer.m_85982_(matrix, x, (float)this.lineHeight(), 0.0f).m_6122_(r, g, b, a).m_7421_(u, v + this.V_SIZE).m_5752_();
        buffer.m_85982_(matrix, x + (float)this.charWidth(), (float)this.lineHeight(), 0.0f).m_6122_(r, g, b, a).m_7421_(u + this.U_SIZE, v + this.V_SIZE).m_5752_();
        buffer.m_85982_(matrix, x + (float)this.charWidth(), 0.0f, 0.0f).m_6122_(r, g, b, a).m_7421_(u + this.U_SIZE, v).m_5752_();
        buffer.m_85982_(matrix, x, 0.0f, 0.0f).m_6122_(r, g, b, a).m_7421_(u, v).m_5752_();
    }

    private int getCharIndex(char ch) {
        if (!this.CHAR_MAP.containsKey(ch)) {
            return this.CHAR_MAP.get('?');
        }
        return this.CHAR_MAP.get(ch);
    }

    private static final class MutableInteger {
        public int value;

        private MutableInteger() {
        }
    }

    private static final class FontRenderTypes
    extends RenderType {
        public static RenderType create(ResourceLocation texture) {
            return FontRenderTypes.m_173215_((String)"markdown_manual/bitmap_font", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173101_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110687_(f_110115_).m_110691_(false));
        }

        private FontRenderTypes() {
            super("", DefaultVertexFormat.f_85814_, VertexFormat.Mode.QUADS, 256, false, false, () -> {}, () -> {});
            throw new UnsupportedOperationException("No meant to be instantiated.");
        }
    }
}

