/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.world.biome;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import potionstudios.byg.BYG;
import potionstudios.byg.mixin.access.OverworldBiomeBuilderAccess;
import terrablender.api.BiomeProvider;
import terrablender.api.ParameterUtils;
import terrablender.worldgen.TBClimate;

public class BYGBiomeProvider
extends BiomeProvider {
    private static int count = 0;
    private final OverworldBiomeBuilder overworldBiomeBuilder = new OverworldBiomeBuilder();
    private final Set<ResourceKey<Biome>> bygKeys = new ObjectOpenHashSet();
    private final Map<ResourceKey<Biome>, ResourceKey<Biome>> swapper;

    public BYGBiomeProvider(int overworldWeight, ResourceKey<Biome>[][] oceans, ResourceKey<Biome>[][] middleBiomes, ResourceKey<Biome>[][] middleBiomesVariant, ResourceKey<Biome>[][] plateauBiomes, ResourceKey<Biome>[][] plateauBiomesVariant, ResourceKey<Biome>[][] extremeHills, Map<ResourceKey<Biome>, ResourceKey<Biome>> swapper) {
        super(BYG.createLocation("biome_provider_" + count++), overworldWeight);
        this.swapper = swapper;
        OverworldBiomeBuilderAccess overworldBiomeBuilderAccess = (OverworldBiomeBuilderAccess)this.overworldBiomeBuilder;
        overworldBiomeBuilderAccess.setOCEANS(oceans);
        overworldBiomeBuilderAccess.setMIDDLE_BIOMES(middleBiomes);
        overworldBiomeBuilderAccess.setMIDDLE_BIOMES_VARIANT(middleBiomesVariant);
        overworldBiomeBuilderAccess.setPLATEAU_BIOMES(plateauBiomes);
        overworldBiomeBuilderAccess.setPLATEAU_BIOMES_VARIANT(plateauBiomesVariant);
        overworldBiomeBuilderAccess.setEXTREME_HILLS(extremeHills);
        BYGBiomeProvider.dumpArrays(biomeResourceKey -> {
            if (biomeResourceKey != null && biomeResourceKey != Biomes.f_48173_) {
                this.bygKeys.add((ResourceKey<Biome>)biomeResourceKey);
                if (swapper.containsValue(biomeResourceKey)) {
                    throw new IllegalArgumentException("Swapper cannot contain elements found in the temperature arrays.");
                }
            }
        }, oceans, middleBiomes, middleBiomesVariant, plateauBiomes, plateauBiomesVariant, extremeHills);
    }

    public void addOverworldBiomes(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        ((OverworldBiomeBuilderAccess)this.overworldBiomeBuilder).invokeAddBiomes(parameterPointResourceKeyPair -> {
            ResourceKey biomeKey = (ResourceKey)parameterPointResourceKeyPair.getSecond();
            if (this.bygKeys.contains(biomeKey)) {
                mapper.accept(new Pair((Object)ParameterUtils.convertParameterPoint((Climate.ParameterPoint)((Climate.ParameterPoint)parameterPointResourceKeyPair.getFirst()), (Climate.Parameter)this.getUniquenessParameter()), (Object)biomeKey));
            }
            if (this.swapper.containsKey(biomeKey)) {
                mapper.accept(new Pair((Object)ParameterUtils.convertParameterPoint((Climate.ParameterPoint)((Climate.ParameterPoint)parameterPointResourceKeyPair.getFirst()), (Climate.Parameter)this.getUniquenessParameter()), this.swapper.get(biomeKey)));
            }
        });
    }

    @SafeVarargs
    private static void dumpArrays(Consumer<ResourceKey<Biome>> biomeConsumer, ResourceKey<Biome>[][] ... resourceKeys) {
        ResourceKey<Biome>[][][] resourceKeyArray = resourceKeys;
        int n = resourceKeyArray.length;
        for (int i = 0; i < n; ++i) {
            ResourceKey<Biome>[][] resourceKey;
            ResourceKey<Biome>[][] resourceKeyArray2 = resourceKey = resourceKeyArray[i];
            int n2 = resourceKeyArray2.length;
            for (int j = 0; j < n2; ++j) {
                ResourceKey<Biome>[] keys;
                for (ResourceKey<Biome> key : keys = resourceKeyArray2[j]) {
                    biomeConsumer.accept(key);
                }
            }
        }
    }
}

