/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;

public class BYGUtil {
    public static final ThreadLocal<RegistryAccess> CAPTURED_REGISTRY_ACCESS = ThreadLocal.withInitial(() -> null);

    public static void captureRegistryAccess(RegistryAccess registryAccess) {
        CAPTURED_REGISTRY_ACCESS.set(registryAccess);
    }

    public static <V> List<List<V>> convert2DArray(V[][] arrayToConvert) {
        ArrayList<List<V>> convertedArrays = new ArrayList<List<V>>();
        for (V[] vs : arrayToConvert) {
            convertedArrays.add(Arrays.asList(vs));
        }
        return convertedArrays;
    }

    public static <T> ResourceKey<T>[][] convert2DResourceKeyArrayTo2DList(List<List<ResourceKey<T>>> listToConvert) {
        ArrayList<ResourceKey[]> resultList = new ArrayList<ResourceKey[]>(listToConvert.size());
        for (List<ResourceKey<T>> vs : listToConvert) {
            resultList.add((ResourceKey[])vs.toArray(ResourceKey[]::new));
        }
        return (ResourceKey[][])resultList.toArray(x$0 -> new ResourceKey[x$0][]);
    }

    public static <T> String dumpRegistry(Registry<T> registry) {
        StringBuilder registryElements = new StringBuilder();
        for (int i = 0; i < registry.m_6579_().size(); ++i) {
            Object object = registry.m_7942_(i);
            registryElements.append(i).append(". \"").append(registry.m_7981_(object).toString()).append("\"\n");
        }
        return registryElements.toString();
    }
}

