/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.server.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.PrimaryLevelData;

public class GenDataCommand {
    public static void dataGenCommand(CommandDispatcher<CommandSourceStack> dispatcher, Collection<String> modIdList) {
        String commandString = "gendata";
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).then(Commands.m_82129_((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82981_(modIdList.stream(), (SuggestionsBuilder)sb)).executes(cs -> {
            GenDataCommand.createBiomeDatapack((String)cs.getArgument("modid", String.class), (CommandContext<CommandSourceStack>)cs);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).redirect((CommandNode)source));
    }

    public static void createBiomeDatapack(String modId, CommandContext<CommandSourceStack> commandSource) {
        ArrayList biomeList = new ArrayList();
        boolean stopSpamFlag = false;
        Path dataPackPath = GenDataCommand.dataPackPath(((CommandSourceStack)commandSource.getSource()).m_81372_().m_142572_().m_129843_(LevelResource.f_78180_), modId);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        RegistryAccess manager = ((CommandSourceStack)commandSource.getSource()).m_81372_().m_5962_();
        Registry biomeRegistry = manager.m_175515_(Registry.f_122885_);
        Registry featuresRegistry = manager.m_175515_(Registry.f_122881_);
        Registry structuresRegistry = manager.m_175515_(Registry.f_122882_);
        Registry carverRegistry = manager.m_175515_(Registry.f_122880_);
        Registry structureProcessorRegistry = manager.m_175515_(Registry.f_122883_);
        Function dimensionGeneratorSettingsCodec = JsonOps.INSTANCE.withEncoder((Encoder)WorldGenSettings.f_64600_);
        DataResult jsonResult = (DataResult)dimensionGeneratorSettingsCodec.apply(((PrimaryLevelData)((CommandSourceStack)commandSource.getSource()).m_81372_().m_6106_()).m_5961_());
        try {
            Path worldImportPath = GenDataCommand.worldImportJsonPath(dataPackPath.getParent(), "world_settings");
            Files.createDirectories(worldImportPath.getParent(), new FileAttribute[0]);
            Files.write(worldImportPath, gson.toJson((JsonElement)jsonResult.get().left().get()).getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GenDataCommand.createJson(modId, dataPackPath, gson, featuresRegistry, ConfiguredFeature.f_65374_);
        GenDataCommand.createJson(modId, dataPackPath, gson, carverRegistry, ConfiguredWorldCarver.f_64847_);
        GenDataCommand.createJson(modId, dataPackPath, gson, structuresRegistry, ConfiguredStructureFeature.f_65401_);
        GenDataCommand.createJson(modId, dataPackPath, gson, structureProcessorRegistry, StructureProcessorType.f_74468_);
        GenDataCommand.createBiomeJsonAndPackMcMeta(modId, commandSource, dataPackPath, gson, (Registry<Biome>)biomeRegistry, featuresRegistry, structuresRegistry, carverRegistry);
    }

    private static void createBiomeJsonAndPackMcMeta(String modId, CommandContext<CommandSourceStack> commandSource, Path dataPackPath, Gson gson, Registry<Biome> biomeRegistry, Registry<ConfiguredFeature<?, ?>> featuresRegistry, Registry<ConfiguredStructureFeature<?, ?>> structuresRegistry, Registry<ConfiguredWorldCarver<?>> carverRegistry) {
        int hits = 0;
        int failedHits = 0;
        for (Map.Entry entry : biomeRegistry.m_6579_()) {
            ResourceLocation key = ((ResourceKey)entry.getKey()).m_135782_();
            Biome biome = (Biome)entry.getValue();
            if (!key.toString().contains(modId)) continue;
            ++hits;
            Path biomeJsonPath = GenDataCommand.biomeJsonPath(dataPackPath, key, modId);
            Function function = JsonOps.INSTANCE.withEncoder((Encoder)Biome.f_47431_);
        }
        try {
            GenDataCommand.createPackMCMeta(dataPackPath, modId);
        }
        catch (IOException e) {
            ((CommandSourceStack)commandSource.getSource()).m_81352_((Component)new TranslatableComponent("commands.gendata.mcmeta.failed", new Object[]{modId}).m_130938_(text -> text.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED))));
        }
        MutableComponent filePathText = new TextComponent(dataPackPath.toString()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(text -> text.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, dataPackPath.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("commands.gendata.hovertext"))));
        MutableComponent filePathText2 = new TextComponent("https://github.com/CorgiTaco/BYG/issues/194").m_130940_(ChatFormatting.UNDERLINE).m_130938_(text -> text.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/CorgiTaco/BYG/issues/194")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("commands.gendata.hovertext.link"))));
        if (failedHits > 0) {
            ((CommandSourceStack)commandSource.getSource()).m_81352_((Component)new TranslatableComponent("commands.gendata.failed.parse.recommend.new.world", new Object[]{filePathText2}).m_130938_(text -> text.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))));
        }
        if (hits > 0) {
            ((CommandSourceStack)commandSource.getSource()).m_81354_((Component)new TranslatableComponent("commands.gendata.success", new Object[]{commandSource.getArgument("modid", String.class), filePathText}), false);
        } else {
            ((CommandSourceStack)commandSource.getSource()).m_81352_((Component)new TranslatableComponent("commands.gendata.listisempty", new Object[]{modId}).m_130938_(text -> text.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED))));
        }
    }

    private static <T> void createJson(String modId, Path dataPackPath, Gson gson, Registry<T> registry, Codec<Supplier<T>> encoder) {
        for (Map.Entry entry : registry.m_6579_()) {
            Optional optional;
            Function featureCodec = JsonOps.INSTANCE.withEncoder(encoder);
            Object object = entry.getValue();
            if (!((ResourceKey)entry.getKey()).m_135782_().toString().contains(modId) || object == null || !Objects.requireNonNull(registry.m_7981_(object)).toString().contains(modId) || !(optional = ((DataResult)featureCodec.apply(() -> object)).result()).isPresent()) continue;
            try {
                Path cfPath = GenDataCommand.createPath(dataPackPath, Objects.requireNonNull(registry.m_7981_(object)), modId, registry.m_123023_());
                Files.createDirectories(cfPath.getParent(), new FileAttribute[0]);
                Files.write(cfPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static Path worldImportJsonPath(Path path, String jsonName) {
        return path.resolve("import/" + jsonName + ".json");
    }

    private static <T> Path createPath(Path path, ResourceLocation identifier, String modId, ResourceKey<? extends Registry<T>> registry) {
        return path.resolve("data/" + modId + "/" + registry.m_135782_().toString().replace("minecraft:", "") + "/" + identifier.m_135815_() + ".json");
    }

    private static Path biomeJsonPath(Path path, ResourceLocation identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/biome/" + identifier.m_135815_() + ".json");
    }

    private static Path dataPackPath(Path path, String modId) {
        return path.resolve("gendata/" + modId + "-custom");
    }

    private static void createPackMCMeta(Path dataPackPath, String modID) throws IOException {
        String fileString = "{\n\t\"pack\":{\n\t\t\"pack_format\": 6,\n\t\t\"description\": \"Custom biome datapack for " + modID + ".\"\n\t}\n}\n";
        Files.write(dataPackPath.resolve("pack.mcmeta"), fileString.getBytes(), new OpenOption[0]);
    }
}

