/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockDataGenerator {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String[] WOOD_TYPES = new String[]{"_stairs", "_slab", "_button", "_pressure_plate", "_planks", "_bookshelf", "_fence", "_fence_gate", "_trapdoor", "_craft_table", "_boat", "_sign"};
    public static final String[] STONE_TYPES = new String[]{"_wall", "_stairs", "_slab", "_button", "_pressure_plate"};
    public static final String[] STONE_CUTTER_TYPES = new String[]{"_wall", "_stairs", "_slab"};

    public static void makeBYGLangFile(String filePath) {
        ArrayList<String> blockIDList = new ArrayList<String>();
        ArrayList<String> itemIDList = new ArrayList<String>();
        ArrayList<String> biomeIDList = new ArrayList<String>();
        for (Block block : Registry.f_122824_) {
            String blockID = Objects.requireNonNull(Registry.f_122824_.m_7981_((Object)block)).toString();
            if (!blockID.contains("byg")) continue;
            blockIDList.add(blockID.replace("byg:", ""));
        }
        for (Item item : Registry.f_122827_) {
            String itemID = Objects.requireNonNull(Registry.f_122827_.m_7981_((Object)item)).toString();
            if (!itemID.contains("byg")) continue;
            itemIDList.add(itemID.replace("byg:", ""));
        }
        for (Biome biome : BuiltinRegistries.f_123865_) {
            String biomeID = Objects.requireNonNull(BuiltinRegistries.f_123865_.m_7981_((Object)biome)).toString();
            if (!biomeID.contains("byg")) continue;
            biomeIDList.add(biomeID.replace("byg:", ""));
        }
        BlockDataGenerator.createLangFile(filePath, "byg", blockIDList, biomeIDList, itemIDList);
    }

    public static void createLangFile(String langPath, String modID, List<String> idList, List<String> biomeIDs, List<String> itemIDs) {
        try {
            String blockTranslation;
            String blockLangLine;
            FileWriter fileWriter = new FileWriter(langPath);
            Gson prettyPrinting = new GsonBuilder().setPrettyPrinting().create();
            fileWriter.write(StringEscapeUtils.unescapeJava((String)"{\n\""));
            for (String id : biomeIDs) {
                String biomePath = "\"biome." + modID + "." + id;
                blockLangLine = biomePath + "\":\"" + WordUtils.capitalize((String)id.replace("_", " ")) + "\",\n";
                blockTranslation = prettyPrinting.toJson((JsonElement)new JsonPrimitive(blockLangLine));
                blockTranslation = StringEscapeUtils.unescapeJava((String)blockTranslation);
                blockTranslation = StringEscapeUtils.unescapeJava((String)blockTranslation.replace("\"\"", ""));
                blockTranslation = blockTranslation.replace("{", "\",\n}");
                blockTranslation = blockTranslation.replace("\" \n\"\"}", "\",\n}");
                fileWriter.write(blockTranslation);
            }
            for (String id : idList) {
                String blockPath = "\"block." + modID + "." + id;
                blockLangLine = blockPath + "\":\"" + WordUtils.capitalize((String)id.replace("_", " ")) + "\",\n";
                blockTranslation = prettyPrinting.toJson((JsonElement)new JsonPrimitive(blockLangLine));
                blockTranslation = StringEscapeUtils.unescapeJava((String)blockTranslation);
                blockTranslation = StringEscapeUtils.unescapeJava((String)blockTranslation.replace("\"\"", ""));
                blockTranslation = blockTranslation.replace("{", "\",\n}");
                blockTranslation = blockTranslation.replace("\" \n\"\"}", "\",\n}");
                fileWriter.write(blockTranslation);
            }
            for (int idx = 0; idx < itemIDs.size(); ++idx) {
                String id;
                id = itemIDs.get(idx);
                String itemPath = "\"item." + modID + "." + id;
                String itemLangLine = itemPath + "\":\"" + WordUtils.capitalize((String)id.replace("_", " ")) + "\",\n";
                if (idx == idList.size() - 1) {
                    itemLangLine = itemPath + "\":\"" + WordUtils.capitalize((String)id.replace("_", " ")) + "\"\n";
                }
                String itemTranslation = prettyPrinting.toJson((JsonElement)new JsonPrimitive(itemLangLine));
                itemTranslation = StringEscapeUtils.unescapeJava((String)itemTranslation);
                itemTranslation = StringEscapeUtils.unescapeJava((String)itemTranslation.replace("\"\"", ""));
                itemTranslation = itemTranslation.replace("{", "\",\n}");
                itemTranslation = itemTranslation.replace("\" \n\"\"}", "\",\n}");
                fileWriter.write(itemTranslation);
            }
            String endBracket = StringEscapeUtils.unescapeJava((String)"}");
            fileWriter.write(endBracket);
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.error(modID + "'s en_us lang file failed to generate.");
        }
    }

    public static void createWoodRecipeGenerator(String absolutePath, String modID, String woodID, boolean hasBoat, boolean hasCraftingTable, boolean hasSign) {
        ArrayList<String> woodTypes = new ArrayList<String>();
        for (String woodType : WOOD_TYPES) {
            String modifiedID = woodID + woodType;
            if (modifiedID.contains("_boat")) {
                if (!hasBoat) continue;
                woodTypes.add(modifiedID);
                continue;
            }
            if (modifiedID.contains("_crafting_table")) {
                if (!hasCraftingTable) continue;
                woodTypes.add(modifiedID);
                continue;
            }
            if (modifiedID.contains("_sign")) {
                if (!hasSign) continue;
                woodTypes.add(modifiedID);
                continue;
            }
            woodTypes.add(modifiedID);
        }
        BlockDataGenerator.createWoodRecipeGenerator(absolutePath, modID, woodTypes);
    }

    public static void generateAllStoneRecipes(String absolutePath, String modID, String stoneID) {
        BlockDataGenerator.createStoneRecipeGenerator(absolutePath, modID, stoneID);
        BlockDataGenerator.createStoneCutterGenerator(absolutePath, modID, stoneID);
    }

    public static void createStoneRecipeGenerator(String absolutePath, String modID, String stoneID) {
        ArrayList<String> stoneTypes = new ArrayList<String>();
        for (String woodType : STONE_TYPES) {
            String modifiedID = stoneID + woodType;
            stoneTypes.add(modifiedID);
        }
        BlockDataGenerator.createStoneRecipeGenerator(absolutePath, modID, stoneTypes);
    }

    public static void createStoneCutterGenerator(String absolutePath, String modID, String stoneID) {
        ArrayList<String> stoneTypes = new ArrayList<String>();
        for (String woodType : STONE_CUTTER_TYPES) {
            String modifiedID = stoneID + woodType;
            stoneTypes.add(modifiedID);
        }
        BlockDataGenerator.createStoneCutterRecipes(absolutePath, modID, stoneTypes);
    }

    private static void createStoneRecipeGenerator(String absolutePath, String modID, List<String> idList) {
        ArrayList<Pair<String, String>> filterRecipeList = new ArrayList<Pair<String, String>>();
        String slab = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"stone_slab\",\n  \"pattern\": [\n    \"###\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\",\n    \"count\": 6\n  }\n}";
        String stairs = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"id\",\n  \"pattern\": [\n    \"#  \",\n    \"## \",\n    \"###\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\",\n    \"count\": 4\n  }\n}";
        String button = "{\n  \"type\": \"minecraft:crafting_shapeless\",\n  \"group\": \"stone_button\",\n  \"ingredients\": [\n    {\n      \"item\": \"key\"\n    }\n  ],\n  \"result\": {\n    \"item\": \"id\"\n  }\n}";
        String pressurePlate = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"stone_pressure_plate\",\n  \"pattern\": [\n    \"##\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\"\n  }\n}";
        String wall = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"pattern\": [\n    \"###\",\n    \"###\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\"\n    \"count\": 6\n  }\n}";
        filterRecipeList.add(new Pair((Object)"_slab", (Object)slab));
        filterRecipeList.add(new Pair((Object)"_stairs", (Object)stairs));
        filterRecipeList.add(new Pair((Object)"_button", (Object)button));
        filterRecipeList.add(new Pair((Object)"_pressure_plate", (Object)pressurePlate));
        filterRecipeList.add(new Pair((Object)"_wall", (Object)wall));
        BlockDataGenerator.createCustomJsonRecipeGenerator(absolutePath, modID, idList, "key", "id", filterRecipeList, false);
    }

    private static void createWoodRecipeGenerator(String absolutePath, String modID, List<String> idList) {
        ArrayList<Pair<String, String>> filterRecipeList = new ArrayList<Pair<String, String>>();
        String plankRecipe = "{\n  \"type\": \"minecraft:crafting_shapeless\",\n  \"group\": \"planks\",\n  \"ingredients\": [\n    {\n      \"tag\": \"key\"\n    }\n  ],\n  \"result\": {\n    \"item\": \"id\",\n    \"count\": 4\n  }\n}";
        String slab = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"wooden_slab\",\n  \"pattern\": [\n    \"###\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\",\n    \"count\": 6\n  }\n}";
        String stairs = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"id\",\n  \"pattern\": [\n    \"#  \",\n    \"## \",\n    \"###\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\",\n    \"count\": 4\n  }\n}";
        String bookShelf = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"pattern\": [\n    \"###\",\n    \"XXX\",\n    \"###\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    },\n    \"X\": {\n      \"item\": \"minecraft:book\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\"\n  }\n}";
        String button = "{\n  \"type\": \"minecraft:crafting_shapeless\",\n  \"group\": \"wooden_button\",\n  \"ingredients\": [\n    {\n      \"item\": \"key\"\n    }\n  ],\n  \"result\": {\n    \"item\": \"id\"\n  }\n}";
        String pressurePlate = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"wooden_pressure_plate\",\n  \"pattern\": [\n    \"##\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\"\n  }\n}";
        String fence = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"wooden_fence\",\n  \"pattern\": [\n    \"W#W\",\n    \"W#W\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"minecraft:stick\"\n    },\n    \"W\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\",\n    \"count\": 3\n  }\n}";
        String fenceGate = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"wooden_fence_gate\",\n  \"pattern\": [\n    \"#W#\",\n    \"#W#\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"minecraft:stick\"\n    },\n    \"W\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\"\n  }\n}";
        String trapDoor = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"wooden_trapdoor\",\n  \"pattern\": [\n    \"###\",\n    \"###\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\",\n    \"count\": 2\n  }\n}";
        String craftingTable = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"pattern\": [\n    \"##\",\n    \"##\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\"\n  }\n}";
        String boat = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"boat\",\n  \"pattern\": [\n    \"# #\",\n    \"###\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\"\n  }\n}";
        String door = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"wooden_door\",\n  \"pattern\": [\n    \"##\",\n    \"##\",\n    \"##\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\",\n    \"count\": 3\n  }\n}";
        String sign = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"sign\",\n  \"pattern\": [\n    \"###\",\n    \"###\",\n    \" X \"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    },\n    \"X\": {\n      \"item\": \"minecraft:stick\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\",\n    \"count\": 3\n  }\n}";
        String wood = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"bark\",\n  \"pattern\": [\n    \"##\",\n    \"##\"\n  ],\n  \"key\": {\n    \"#\": {\n      \"item\": \"key\"\n    }\n  },\n  \"result\": {\n    \"item\": \"id\",\n    \"count\": 3\n  }\n}";
        filterRecipeList.add(new Pair((Object)"_planks", (Object)plankRecipe));
        filterRecipeList.add(new Pair((Object)"_wood", (Object)wood));
        filterRecipeList.add(new Pair((Object)"_slab", (Object)slab));
        filterRecipeList.add(new Pair((Object)"_stairs", (Object)stairs));
        filterRecipeList.add(new Pair((Object)"_bookshelf", (Object)bookShelf));
        filterRecipeList.add(new Pair((Object)"_button", (Object)button));
        filterRecipeList.add(new Pair((Object)"_pressure_plate", (Object)pressurePlate));
        filterRecipeList.add(new Pair((Object)"_fence", (Object)fence));
        filterRecipeList.add(new Pair((Object)"_fence_gate", (Object)fenceGate));
        filterRecipeList.add(new Pair((Object)"_trapdoor", (Object)trapDoor));
        filterRecipeList.add(new Pair((Object)"_crafting_table", (Object)craftingTable));
        filterRecipeList.add(new Pair((Object)"_boat", (Object)boat));
        filterRecipeList.add(new Pair((Object)"_door", (Object)door));
        filterRecipeList.add(new Pair((Object)"_sign", (Object)sign));
        BlockDataGenerator.createCustomJsonRecipeGenerator(absolutePath, modID, idList, "key", "id", filterRecipeList, true);
    }

    private static void createStoneCutterRecipes(String absolutePath, String modID, List<String> idList) {
        ArrayList<Triple<String, String, String>> filterRecipeList = new ArrayList<Triple<String, String, String>>();
        String recipe = "{\n  \"type\": \"minecraft:stonecutting\",\n  \"ingredient\": {\n    \"item\": \"key\"\n  },\n  \"result\": \"id\",\n  \"count\": resultcount\n}";
        filterRecipeList.add(new Triple<String, String, String>("_stairs", "1", recipe));
        filterRecipeList.add(new Triple<String, String, String>("_slab", "2", recipe));
        filterRecipeList.add(new Triple<String, String, String>("_wall", "1", recipe));
        BlockDataGenerator.createStoneCutterRecipeGenerator(absolutePath, modID, idList, "key", "id", "resultcount", filterRecipeList);
    }

    public static void createOreRecipe(String absolutePath, String modID, List<String> idList, OreType oreType, String ingot) {
        String recipe = oreType.getRecipe();
        BlockDataGenerator.createCustomOreJsonLootTableGenerator(absolutePath, modID, idList, "key", "id", recipe, ingot);
    }

    public static void createCustomJsonRecipeGenerator(String absolutePath, String modID, List<String> idList, String replaceInKey, String replaceInResult, List<Pair<String, String>> filterRecipeList, boolean isWood) {
        idList.forEach(id -> {
            for (Pair pair : filterRecipeList) {
                String filter = (String)pair.getFirst();
                String recipe = (String)pair.getSecond();
                recipe = isWood ? (filter.equals("_planks") ? recipe.replace(replaceInKey, modID + ":" + id.replace(filter, "_log")) : recipe.replace(replaceInKey, modID + ":" + id.replace(filter, "_planks"))) : recipe.replace(replaceInKey, modID + ":" + id);
                recipe = recipe.replace(replaceInResult, modID + ":" + id);
                if (!id.contains(filter)) continue;
                String path = absolutePath + "\\" + id + ".json";
                try {
                    FileWriter fileWriter = new FileWriter(path);
                    Gson prettyPrinting = new GsonBuilder().setPrettyPrinting().create();
                    String string = prettyPrinting.toJson((JsonElement)new JsonPrimitive(recipe));
                    string = StringEscapeUtils.unescapeJava((String)string);
                    string = string.replace("\"{", "{");
                    string = string.replace("}\"", "}");
                    fileWriter.write(string);
                    fileWriter.close();
                }
                catch (IOException e) {
                    LOGGER.error("File failed at: " + path);
                    e.printStackTrace();
                }
            }
        });
    }

    public static void createCustomJsonRecipeGenerator(String absolutePath, String modID, List<String> idList, String replaceInKey, String replaceInResult, String replaceCount, List<Triple<String, String, String>> filterRecipeList) {
        idList.forEach(id -> {
            for (Triple pair : filterRecipeList) {
                String filter = (String)pair.getLeft();
                String count = (String)pair.getMiddle();
                String recipe = (String)pair.getMiddle();
                recipe = recipe.replace(replaceInKey, modID + ":" + id);
                recipe = recipe.replace(replaceInResult, (CharSequence)id);
                recipe = recipe.replace(replaceCount, count);
                if (!id.contains(filter)) continue;
                String path = absolutePath + "\\" + id + ".json";
                try {
                    FileWriter fileWriter = new FileWriter(path);
                    Gson prettyPrinting = new GsonBuilder().setPrettyPrinting().create();
                    String string = prettyPrinting.toJson((JsonElement)new JsonPrimitive(recipe));
                    string = StringEscapeUtils.unescapeJava((String)string);
                    string = string.replace("\"{", "{");
                    string = string.replace("}\"", "}");
                    fileWriter.write(string);
                    fileWriter.close();
                }
                catch (IOException e) {
                    LOGGER.error("File failed at: " + path);
                    e.printStackTrace();
                }
            }
        });
    }

    public static void createCustomOreJsonLootTableGenerator(String absolutePath, String modID, List<String> idList, String replaceInKey, String replaceInResult, String recipe, String ingot) {
        idList.forEach(id -> {
            String modifiableRecipe = recipe;
            modifiableRecipe = modifiableRecipe.replace(replaceInKey, modID + ":" + id);
            modifiableRecipe = modifiableRecipe.replace(replaceInResult, ingot);
            String path = absolutePath + "\\" + id + ".json";
            try {
                FileWriter fileWriter = new FileWriter(path);
                Gson prettyPrinting = new GsonBuilder().setPrettyPrinting().create();
                String string = prettyPrinting.toJson((JsonElement)new JsonPrimitive(modifiableRecipe));
                string = StringEscapeUtils.unescapeJava((String)string);
                string = string.replace("\"{", "{");
                string = string.replace("}\"", "}");
                fileWriter.write(string);
                fileWriter.close();
            }
            catch (IOException e) {
                LOGGER.error("File failed at: " + path);
                e.printStackTrace();
            }
        });
    }

    public static void createCustomJsonRecipeGenerator(String absolutePath, String modID, List<String> idList, String replaceInKey, String replaceInResult, String replaceCount, String filter, String recipe, String count) {
        idList.forEach(id -> {
            String modifiableRecipe = recipe;
            modifiableRecipe = modifiableRecipe.replace(replaceInKey, modID + ":" + id);
            modifiableRecipe = modifiableRecipe.replace(replaceInResult, (CharSequence)id);
            modifiableRecipe = modifiableRecipe.replace(replaceCount, count);
            if (id.contains(filter)) {
                String path = absolutePath + "\\" + id + ".json";
                try {
                    FileWriter fileWriter = new FileWriter(path);
                    Gson prettyPrinting = new GsonBuilder().setPrettyPrinting().create();
                    String string = prettyPrinting.toJson((JsonElement)new JsonPrimitive(modifiableRecipe));
                    string = StringEscapeUtils.unescapeJava((String)string);
                    string = string.replace("\"{", "{");
                    string = string.replace("}\"", "}");
                    fileWriter.write(string);
                    fileWriter.close();
                }
                catch (IOException e) {
                    LOGGER.error("File failed at: " + path);
                    e.printStackTrace();
                }
            }
        });
    }

    public static void createStoneCutterRecipeGenerator(String absolutePath, String modID, List<String> idList, String replaceInKey, String replaceInResult, String replaceCount, List<Triple<String, String, String>> filterRecipeList) {
        idList.forEach(id -> {
            for (Triple pair : filterRecipeList) {
                String filter = (String)pair.getLeft();
                String count = (String)pair.getMiddle();
                String recipe = (String)pair.getRight();
                recipe = recipe.replace(replaceInKey, modID + ":" + id);
                recipe = recipe.replace(replaceInResult, (CharSequence)id);
                recipe = recipe.replace(replaceCount, count);
                if (!id.contains(filter)) continue;
                String path = absolutePath + "\\" + id + "_from_" + id.replace(filter, "_") + "stonecutting.json";
                try {
                    FileWriter fileWriter = new FileWriter(path);
                    Gson prettyPrinting = new GsonBuilder().setPrettyPrinting().create();
                    String string = prettyPrinting.toJson((JsonElement)new JsonPrimitive(recipe));
                    string = StringEscapeUtils.unescapeJava((String)string);
                    string = string.replace("\"{", "{");
                    string = string.replace("}\"", "}");
                    fileWriter.write(string);
                    fileWriter.close();
                }
                catch (IOException e) {
                    LOGGER.error("File failed at: " + path);
                    e.printStackTrace();
                }
            }
        });
    }

    public static class Triple<A, B, C> {
        private final A left;
        private final B middle;
        private final C right;

        public Triple(A left, B middle, C right) {
            this.left = left;
            this.middle = middle;
            this.right = right;
        }

        public A getLeft() {
            return this.left;
        }

        public B getMiddle() {
            return this.middle;
        }

        public C getRight() {
            return this.right;
        }
    }

    public static enum OreType {
        COAL("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:alternatives\",\n          \"children\": [\n            {\n              \"type\": \"minecraft:item\",\n              \"conditions\": [\n                {\n                  \"condition\": \"minecraft:match_tool\",\n                  \"predicate\": {\n                    \"enchantments\": [\n                      {\n                        \"enchantment\": \"minecraft:silk_touch\",\n                        \"levels\": {\n                          \"min\": 1\n                        }\n                      }\n                    ]\n                  }\n                }\n              ],\n              \"name\": \"key\"\n            },\n            {\n              \"type\": \"minecraft:item\",\n              \"functions\": [\n                {\n                  \"function\": \"minecraft:apply_bonus\",\n                  \"enchantment\": \"minecraft:fortune\",\n                  \"formula\": \"minecraft:ore_drops\"\n                },\n                {\n                  \"function\": \"minecraft:explosion_decay\"\n                }\n              ],\n              \"name\": \"id\"\n            }\n          ]\n        }\n      ]\n    }\n  ]\n}"),
        LAPIS("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:alternatives\",\n          \"children\": [\n            {\n              \"type\": \"minecraft:item\",\n              \"conditions\": [\n                {\n                  \"condition\": \"minecraft:match_tool\",\n                  \"predicate\": {\n                    \"enchantments\": [\n                      {\n                        \"enchantment\": \"minecraft:silk_touch\",\n                        \"levels\": {\n                          \"min\": 1\n                        }\n                      }\n                    ]\n                  }\n                }\n              ],\n              \"name\": \"key\"\n            },\n            {\n              \"type\": \"minecraft:item\",\n              \"functions\": [\n                {\n                  \"function\": \"minecraft:set_count\",\n                  \"count\": {\n                    \"min\": 4.0,\n                    \"max\": 9.0,\n                    \"type\": \"minecraft:uniform\"\n                  }\n                },\n                {\n                  \"function\": \"minecraft:apply_bonus\",\n                  \"enchantment\": \"minecraft:fortune\",\n                  \"formula\": \"minecraft:ore_drops\"\n                },\n                {\n                  \"function\": \"minecraft:explosion_decay\"\n                }\n              ],\n              \"name\": \"id\"\n            }\n          ]\n        }\n      ]\n    }\n  ]\n}"),
        REDSTONE("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:alternatives\",\n          \"children\": [\n            {\n              \"type\": \"minecraft:item\",\n              \"conditions\": [\n                {\n                  \"condition\": \"minecraft:match_tool\",\n                  \"predicate\": {\n                    \"enchantments\": [\n                      {\n                        \"enchantment\": \"minecraft:silk_touch\",\n                        \"levels\": {\n                          \"min\": 1\n                        }\n                      }\n                    ]\n                  }\n                }\n              ],\n              \"name\": \"key\"\n            },\n            {\n              \"type\": \"minecraft:item\",\n              \"functions\": [\n                {\n                  \"function\": \"minecraft:set_count\",\n                  \"count\": {\n                    \"min\": 4.0,\n                    \"max\": 5.0,\n                    \"type\": \"minecraft:uniform\"\n                  }\n                },\n                {\n                  \"function\": \"minecraft:apply_bonus\",\n                  \"enchantment\": \"minecraft:fortune\",\n                  \"formula\": \"minecraft:uniform_bonus_count\",\n                  \"parameters\": {\n                    \"bonusMultiplier\": 1\n                  }\n                },\n                {\n                  \"function\": \"minecraft:explosion_decay\"\n                }\n              ],\n              \"name\": \"id\"\n            }\n          ]\n        }\n      ]\n    }\n  ]\n}"),
        DIAMOND("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:alternatives\",\n          \"children\": [\n            {\n              \"type\": \"minecraft:item\",\n              \"conditions\": [\n                {\n                  \"condition\": \"minecraft:match_tool\",\n                  \"predicate\": {\n                    \"enchantments\": [\n                      {\n                        \"enchantment\": \"minecraft:silk_touch\",\n                        \"levels\": {\n                          \"min\": 1\n                        }\n                      }\n                    ]\n                  }\n                }\n              ],\n              \"name\": \"key\"\n            },\n            {\n              \"type\": \"minecraft:item\",\n              \"functions\": [\n                {\n                  \"function\": \"minecraft:apply_bonus\",\n                  \"enchantment\": \"minecraft:fortune\",\n                  \"formula\": \"minecraft:ore_drops\"\n                },\n                {\n                  \"function\": \"minecraft:explosion_decay\"\n                }\n              ],\n              \"name\": \"id\"\n            }\n          ]\n        }\n      ]\n    }\n  ]\n}"),
        EMERALD("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:alternatives\",\n          \"children\": [\n            {\n              \"type\": \"minecraft:item\",\n              \"conditions\": [\n                {\n                  \"condition\": \"minecraft:match_tool\",\n                  \"predicate\": {\n                    \"enchantments\": [\n                      {\n                        \"enchantment\": \"minecraft:silk_touch\",\n                        \"levels\": {\n                          \"min\": 1\n                        }\n                      }\n                    ]\n                  }\n                }\n              ],\n              \"name\": \"key\"\n            },\n            {\n              \"type\": \"minecraft:item\",\n              \"functions\": [\n                {\n                  \"function\": \"minecraft:apply_bonus\",\n                  \"enchantment\": \"minecraft:fortune\",\n                  \"formula\": \"minecraft:ore_drops\"\n                },\n                {\n                  \"function\": \"minecraft:explosion_decay\"\n                }\n              ],\n              \"name\": \"id\"\n            }\n          ]\n        }\n      ]\n    }\n  ]\n}");

        private final String recipe;

        private OreType(String recipe) {
            this.recipe = recipe;
        }

        public String getRecipe() {
            return this.recipe;
        }
    }
}

