/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config.json;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.BYGBiomes;
import potionstudios.byg.util.CodecUtil;

public record BiomeDictionaryConfig(Map<ResourceKey<Biome>, List<String>> biomeDictionary) {
    public static final BiomeDictionaryConfig DEFAULT = new BiomeDictionaryConfig((Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), map -> {
        map.put(BYGBiomes.ALLIUM_FIELDS, List.of("PLAINS", "RARE", "LUSH", "OVERWORLD"));
        map.put(BYGBiomes.AMARANTH_FIELDS, List.of("PLAINS", "RARE", "LUSH", "OVERWORLD"));
        map.put(BYGBiomes.ARAUCARIA_SAVANNA, List.of("SAVANNA", "OVERWORLD"));
        map.put(BYGBiomes.ARAUCARIA_SAVANNA, List.of("SAVANNA", "OVERWORLD"));
        map.put(BYGBiomes.ASPEN_FOREST, List.of("FOREST", "OVERWORLD"));
        map.put(BYGBiomes.AUTUMNAL_VALLEY, List.of("PLAINS", "DRY", "OVERWORLD"));
        map.put(BYGBiomes.BAOBAB_SAVANNA, List.of("SAVANNA", "SPARSE", "DRY", "OVERWORLD"));
        map.put(BYGBiomes.BAYOU, List.of("SWAMP", "FOREST", "WET", "OVERWORLD"));
        map.put(BYGBiomes.BOREALIS_GROVE, List.of("FOREST", "OVERWORLD"));
    }));
    public static BiomeDictionaryConfig INSTANCE = null;
    public static final Codec<BiomeDictionaryConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap(CodecUtil.BIOME_CODEC, (Codec)Codec.STRING.listOf()).fieldOf("dictionary").forGetter(overworldBiomeConfig -> overworldBiomeConfig.biomeDictionary)).apply((Applicative)builder, BiomeDictionaryConfig::new));

    public static BiomeDictionaryConfig getConfig(boolean serialize) {
        if (INSTANCE == null || serialize) {
            INSTANCE = BiomeDictionaryConfig.readConfig();
        }
        return INSTANCE;
    }

    private static BiomeDictionaryConfig readConfig() {
        Path path = BYG.CONFIG_PATH.resolve("byg-biome-dictionary.json");
        if (!path.toFile().exists()) {
            JsonElement jsonElement = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)DEFAULT).result().get();
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(jsonElement).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BYG.LOGGER.error(e.toString());
            }
        }
        BYG.LOGGER.info(String.format("\"%s\" was read.", path.toString()));
        try {
            return (BiomeDictionaryConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(path.toFile()))).result().orElseThrow(RuntimeException::new)).getFirst();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return DEFAULT;
        }
    }
}

