/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config;

import java.nio.file.Path;
import java.util.Arrays;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.BYG;
import potionstudios.byg.config.CommentedConfigBuilder;

public class WorldConfig {
    private final CommentedConfigBuilder configHelper;

    public WorldConfig(Path path) {
        this.configHelper = new CommentedConfigBuilder(path);
        this.configHelper.build();
    }

    public static boolean conditionPasses(String conditionString, ResourceKey<Biome> biomeKey, Biome biome) {
        if (conditionString.isEmpty()) {
            return false;
        }
        if (conditionString.equalsIgnoreCase("all")) {
            return true;
        }
        String[] conditions = conditionString.trim().split("\\s*,\\s*");
        String biomeNamespace = biomeKey.m_135782_().m_135827_();
        String biomeLocation = biomeKey.m_135782_().toString();
        for (String condition : conditions) {
            String[] split = condition.split("(?=[\\$#])");
            boolean categoryExists = true;
            for (String result : split) {
                if (result.startsWith("!")) {
                    result = result.substring(1);
                }
                if (!result.startsWith("#")) continue;
                String categoryString = result.substring(1);
                categoryExists = Arrays.stream(Biome.BiomeCategory.values()).anyMatch(bc -> bc.toString().equalsIgnoreCase(categoryString));
                if (categoryExists) continue;
                BYG.LOGGER.error("\"" + categoryString + "\" is not a valid biome category!");
            }
            if (!categoryExists) continue;
            boolean fail = false;
            for (String result : split) {
                if (result.startsWith("!")) {
                    result = result.substring(1);
                }
                if (result.startsWith("#")) {
                    String categoryString = result.substring(1);
                    fail = !biome.m_47567_().m_47645_().equalsIgnoreCase(categoryString);
                    continue;
                }
                if (biomeLocation.equalsIgnoreCase(result) || result.equalsIgnoreCase(biomeNamespace)) continue;
                fail = true;
            }
            boolean isFlipped = condition.startsWith("!");
            if (fail && isFlipped) {
                return true;
            }
            if (fail || isFlipped) continue;
            return true;
        }
        return false;
    }
}

