/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.overworld.river;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec2;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class RiverGenerator {
    private final List<Node> nodes;
    private final Map<ChunkPos, List<Node>> fastNodes;

    public RiverGenerator(FastNoise noise, WorldGenLevel world, BlockPos startPos, ChunkGenerator generator, Predicate<BlockPos> isInvalid, Predicate<BlockPos> isValid, int maxDistance) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        HashMap<ChunkPos, List<Node>> fastNodes = new HashMap<ChunkPos, List<Node>>();
        nodes.add(new Node(startPos, 0));
        int distanceInNodes = maxDistance / 5;
        int startY = startPos.m_123342_();
        for (int i = 1; i < distanceInNodes; ++i) {
            BlockPos pos;
            Node nextNode;
            Node prevNode = (Node)nodes.get(i - 1);
            float angle = noise.GetNoise(prevNode.getPos().m_123341_(), 0.0f, prevNode.getPos().m_123343_());
            Vec2 dAngle = RiverGenerator.get2DAngle(angle * 5.0f, 5.0f);
            BlockPos previousNodePos = prevNode.getPos();
            Vec3i vecAngle = new Vec3i((double)dAngle.f_82470_, 0.0, (double)dAngle.f_82471_);
            BlockPos addedPos = previousNodePos.m_141952_(vecAngle);
            ResourceKey biomeRegistryKey = (ResourceKey)world.m_5962_().m_175515_(Registry.f_122885_).m_7854_((Object)generator.m_62218_().m_183546_(addedPos.m_123341_() >> 2, addedPos.m_123342_() >> 2, addedPos.m_123343_() >> 2, generator.m_183403_())).get();
            int newY = generator.m_156174_(addedPos.m_123341_(), addedPos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)world);
            if (newY > previousNodePos.m_123342_()) {
                newY = previousNodePos.m_123342_();
            }
            if (newY < generator.m_6337_() + 1) {
                newY = generator.m_6337_() + 1;
            }
            if (isInvalid.test((nextNode = new Node(pos = new BlockPos(addedPos.m_123341_(), newY, addedPos.m_123343_()), i)).getPos())) break;
            ChunkPos key = new ChunkPos(nextNode.getPos());
            if (isValid.test(nextNode.getPos())) {
                nodes.add(nextNode);
                fastNodes.computeIfAbsent(key, key2 -> new ArrayList()).add(nextNode);
                this.nodes = nodes;
                this.fastNodes = fastNodes;
                return;
            }
            nodes.add(nextNode);
            fastNodes.computeIfAbsent(key, key2 -> new ArrayList()).add(nextNode);
        }
        this.nodes = null;
        this.fastNodes = null;
    }

    public boolean exists() {
        return this.nodes != null;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Node> getNodesForChunk(ChunkPos pos) {
        return this.fastNodes.get(pos);
    }

    public Set<ChunkPos> getNodeChunkPositions() {
        return this.fastNodes.keySet();
    }

    public BlockPos getFinalPosition() {
        return this.nodes.get(this.nodes.size() - 1).getPos();
    }

    public int getTotalNumberOfNodes() {
        return this.nodes.size();
    }

    public BlockPos getStartPos() {
        return this.nodes.get(0).getPos();
    }

    public static Vec2 get2DAngle(float angle, float length) {
        float x = (float)(Math.sin(angle) * (double)length);
        float y = (float)(Math.cos(angle) * (double)length);
        return new Vec2(x, y);
    }

    static class Node {
        private final int idx;
        private BlockPos pos;

        private Node(BlockPos pos, int idx) {
            this.pos = pos;
            this.idx = idx;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void upgradeY(int y) {
            this.pos = new BlockPos(this.pos.m_123341_(), y, this.pos.m_123343_());
        }

        public int getIdx() {
            return this.idx;
        }
    }
}

