/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.overworld.river;

import java.io.ByteArrayOutputStream;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import potionstudios.byg.common.world.feature.overworld.river.MegaChunkPos;
import potionstudios.byg.common.world.feature.overworld.river.RiverGenerator;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class MegaChunk {
    private final MegaChunkPos megaChunkPos;
    private final BiomeSource provider;
    private final ChunkGenerator chunkGenerator;
    private final Set<Biome> allowedBiomes;
    private final byte[] canyonChunks;
    private RiverGenerator riverGenerator;

    public MegaChunk(MegaChunkPos megaChunkPos, ChunkGenerator chunkGenerator, Set<Biome> allowedBiomes) {
        this.megaChunkPos = megaChunkPos;
        this.chunkGenerator = chunkGenerator;
        this.provider = chunkGenerator.m_62218_();
        this.allowedBiomes = allowedBiomes;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                ChunkPos chunkPos = megaChunkPos.toChunkPos(x, z);
                Biome noiseBiome = chunkGenerator.m_62218_().m_183546_((chunkPos.f_45578_ << 2) + 2, 0, (chunkPos.f_45579_ << 2) + 2, chunkGenerator.m_183403_());
                if (!allowedBiomes.contains(noiseBiome)) continue;
                byteArrayOutputStream.write(MegaChunkPos.packLocalPos(x, z));
            }
        }
        this.canyonChunks = byteArrayOutputStream.toByteArray();
    }

    public int getCount() {
        return this.canyonChunks.length;
    }

    public MegaChunkPos getMegaChunkPos() {
        return this.megaChunkPos;
    }

    public RiverGenerator getRiverGenerator() {
        return this.riverGenerator;
    }

    public void createRiverGeneratorStart(FastNoise noise, WorldGenLevel world, long worldSeed, int maxRiverDistance) {
        WorldgenRandom seedRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(worldSeed));
        seedRandom.m_190064_(934893458905904595L, this.megaChunkPos.getX(), this.megaChunkPos.getZ());
        byte canyonChunkByte = this.canyonChunks[seedRandom.nextInt(this.canyonChunks.length)];
        BlockPos startPos = this.megaChunkPos.unpackLocalPos(canyonChunkByte).m_45615_();
        this.riverGenerator = new RiverGenerator(noise, world, new BlockPos(startPos.m_123341_(), this.chunkGenerator.m_156174_(startPos.m_123341_(), startPos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)world), startPos.m_123343_()), this.chunkGenerator, blockpos -> false, blockpos -> {
            Biome.BiomeCategory category = this.provider.m_183546_(blockpos.m_123341_() >> 2, blockpos.m_123342_() >> 2, blockpos.m_123343_() >> 2, this.chunkGenerator.m_183403_()).m_47567_();
            return category == Biome.BiomeCategory.RIVER || category == Biome.BiomeCategory.OCEAN || this.chunkGenerator.m_142647_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)world) <= this.chunkGenerator.m_6337_();
        }, maxRiverDistance);
    }

    public void createRiverGenerator(FastNoise noise, BlockPos generatorStartPos, WorldGenLevel world, int maxRiverDistance) {
        this.riverGenerator = new RiverGenerator(noise, world, new BlockPos(generatorStartPos.m_123341_(), 218, generatorStartPos.m_123343_()), this.chunkGenerator, blockpos -> false, blockpos -> {
            Biome.BiomeCategory category = this.provider.m_183546_(blockpos.m_123341_() >> 2, blockpos.m_123342_() >> 2, blockpos.m_123343_() >> 2, this.chunkGenerator.m_183403_()).m_47567_();
            return category == Biome.BiomeCategory.RIVER || category == Biome.BiomeCategory.OCEAN || this.chunkGenerator.m_142647_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)world) <= this.chunkGenerator.m_6337_();
        }, maxRiverDistance);
    }
}

