/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import potionstudios.byg.common.world.feature.config.PointyRockConfig;
import potionstudios.byg.common.world.feature.overworld.ChunkCoordinatesFeature;
import potionstudios.byg.common.world.math.noise.fastnoise.FNVector3f;

public class TallPointedRocks
extends ChunkCoordinatesFeature<PointyRockConfig> {
    public TallPointedRocks(Codec<PointyRockConfig> codec) {
        super(codec);
    }

    @Override
    public boolean generate(WorldGenLevel world, Random random, ChunkAccess chunkIn, int x, int z, PointyRockConfig config) {
        config.setUpNoise(world.m_7328_());
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(xPos, 0, zPos);
        FNVector3f fnVector3f = new FNVector3f(x, 0.0f, z);
        config.getNoiseGen().GradientPerturb(fnVector3f);
        float sampleNoise = config.getNoiseGen().GetNoise(fnVector3f.x, fnVector3f.z);
        int groundLevel = chunkIn.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        if (!chunkIn.m_8055_(mutable.m_6630_(groundLevel)).m_60795_() && (double)sampleNoise < 0.43) {
            int valueToReverse = (int)Math.abs((double)((int)((double)sampleNoise * 645.0)) * 1.8);
            int topHeight = (int)((double)valueToReverse - Math.abs((double)(-sampleNoise) * 645.0 * 1.8 - (double)valueToReverse) + 598.5);
            if ((topHeight = (int)((double)TallPointedRocks.redistribute(topHeight, groundLevel) * config.getHeightMultiplier())) > groundLevel) {
                mutable.m_122175_(Direction.UP, topHeight);
                for (int yPos = topHeight; yPos >= groundLevel; --yPos) {
                    if (chunkIn.m_8055_((BlockPos)mutable).m_60795_() && mutable.m_123342_() <= chunkIn.m_151558_()) {
                        chunkIn.m_6978_((BlockPos)mutable, config.getBlockProvider().m_7112_(random, (BlockPos)mutable), false);
                    }
                    mutable.m_122173_(Direction.DOWN);
                }
            }
        }
        return true;
    }

    private static int redistribute(float height, float groundLevel) {
        float halfG = groundLevel * 0.5f;
        height = (height - 125.0f - halfG) / 80.0f;
        float sigmoid = height / (1.0f + Math.abs(height));
        return (int)((170.0f - groundLevel) * sigmoid + halfG + 125.0f);
    }
}

