/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.feature.config.BoulderConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class StackableBoulders
extends Feature<BoulderConfig> {
    protected long seed;
    protected static FastNoise fastNoise;
    public static int stopSpamInt;

    public StackableBoulders(Codec<BoulderConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<BoulderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (BoulderConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, Random random, BlockPos position, BoulderConfig config) {
        this.setSeed(world.m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position.m_6625_(2 + random.nextInt(10)));
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable);
        int stackHeight = random.nextInt(config.getMaxPossibleHeight()) + config.getMinHeight();
        int radius = random.nextInt(config.getMaxPossibleRadius()) + config.getMinRadius();
        BlockState blockStateDown = world.m_8055_(position.m_7495_());
        BlockState blockStateAtPosition = world.m_8055_(position);
        if (blockStateDown.m_60620_((Tag)BlockTags.f_13035_) || blockStateDown.m_60620_((Tag)BlockTags.f_13106_) || blockStateAtPosition.m_60620_((Tag)BlockTags.f_13035_) || blockStateAtPosition.m_60620_((Tag)BlockTags.f_13106_) || blockStateAtPosition.m_60767_() == Material.f_76296_) {
            return false;
        }
        for (int boulderIDX = 0; boulderIDX < stackHeight; ++boulderIDX) {
            int moveOnX = random.nextInt(4);
            if (random.nextInt(2) == 0) {
                moveOnX = -moveOnX;
            }
            int moveOnZ = random.nextInt(4);
            if (random.nextInt(2) == 1) {
                moveOnZ = -moveOnZ;
            }
            mutable.m_122184_(moveOnX, (int)((float)random.nextInt(Math.abs(radius) + 1) * 0.2f + (float)radius * 0.8f) - 3 + -random.nextInt(5), moveOnZ);
            int yPositiveRadius = config.isTopBoulderFlat() && boulderIDX + 1 == stackHeight ? 0 : radius;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= yPositiveRadius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockState blockState;
                        int squaredDistance = x * x + y * y + z * z;
                        if (squaredDistance > radius * radius) continue;
                        mutable2.m_122190_((Vec3i)mutable).m_122184_(x, y, z);
                        double boulderRoughnessNoise = fastNoise.GetNoise((float)mutable2.m_123341_() * 0.04f, (float)mutable2.m_123342_() * 0.01f, (float)mutable2.m_123343_() * 0.04f);
                        if ((float)squaredDistance > (float)(radius * radius) * 0.8f && boulderRoughnessNoise > -0.3 && boulderRoughnessNoise < 0.3 || !this.canBlockPlaceHere(blockState = world.m_8055_((BlockPos)mutable2))) continue;
                        world.m_7731_((BlockPos)mutable2, config.getBlockProvider().m_7112_(random, (BlockPos)mutable2), 3);
                    }
                }
            }
            while (mutable.m_123342_() < world.m_151558_() && !world.m_8055_((BlockPos)mutable).m_60795_()) {
                mutable.m_122173_(Direction.UP);
            }
            if (3 <= (radius = (int)((double)radius / config.getRadiusDivisorPerStack()))) continue;
            if (stopSpamInt != 0) break;
            BYG.LOGGER.debug("BYG: Boulder Radius is too small to continue stacking! Stack stopping at stack height: " + boulderIDX + "\nPlease lower the stack height or increase the boulder radius.");
            ++stopSpamInt;
            break;
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }

    private boolean canBlockPlaceHere(BlockState state) {
        return state.m_60795_() || state.m_60767_() == Material.f_76314_ || state.m_60767_() == Material.f_76300_ || state.m_60767_() == Material.f_76302_ || state.m_60767_() == Material.f_76274_ || state.m_60767_() == Material.f_76317_ || state.m_60767_() == Material.f_76271_ || state.m_60767_() == Material.f_76277_ || state.m_60767_() == Material.f_76305_ || state.m_60767_() == Material.f_76307_ || state.m_60620_((Tag)BlockTags.f_144274_);
    }

    static {
        stopSpamInt = 0;
    }
}

