/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import potionstudios.byg.common.world.feature.config.PointyRockConfig;
import potionstudios.byg.common.world.math.noise.simplex.OpenSimplex2;

public class PointyRockFeature
extends Feature<PointyRockConfig> {
    private static final int RADIUS = 8;
    private static final int BASE_HEIGHT_MULTIPLER = 96;
    private static final double NOISE_FREQUENCY_1 = 0.013;
    private static final double NOISE_FREQUENCY_2 = 0.026;
    private static final double NOISE_RANGE = 1.5;
    private static final double EFFECTIVE_HEIGHT_MULTIPLIER = 0.015625;
    private static final double NOISE_OFFSET_X = 0.45534180126147955;
    private static final double NOISE_OFFSET_Y = 0.12200846792814621;

    public PointyRockFeature(Codec<PointyRockConfig> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<PointyRockConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (PointyRockConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator changedBlock, Random rand, BlockPos position, PointyRockConfig config) {
        long seed1 = rand.nextLong();
        long seed2 = rand.nextLong();
        int baseX = position.m_123341_();
        int baseZ = position.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double effectiveConfiguredHeightMultiplier = config.getHeightMultiplier() * 0.015625;
        for (int z = -7; z < 8; ++z) {
            int worldZ = z + baseZ;
            for (int x = -7; x < 8; ++x) {
                int worldX = x + baseX;
                int distSq = z * z + x * x;
                if (distSq >= 64) continue;
                double falloff = 4096 - distSq * distSq;
                double noise = 1.5 - (double)Math.abs(OpenSimplex2.noise2(seed1, (double)x * 0.013 + 0.45534180126147955, (double)z * 0.013 + 0.12200846792814621)) - (double)Math.abs(OpenSimplex2.noise2(seed2, (double)x * 0.026 + 0.45534180126147955, (double)z * 0.026 + 0.12200846792814621)) * 0.5;
                noise *= falloff;
                int maximumHeight = (int)(noise *= effectiveConfiguredHeightMultiplier);
                int terrainHeight = world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, worldX, worldZ);
                if (maximumHeight <= terrainHeight) continue;
                mutable.m_122178_(worldX, maximumHeight, worldZ);
                for (int y = maximumHeight; y >= terrainHeight; --y) {
                    mutable.m_142448_(y);
                    world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        return true;
    }
}

