/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.BYGFeatures;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.feature.config.SimpleBlockProviderConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class ArchFeature
extends Feature<SimpleBlockProviderConfig> {
    protected long seed;
    protected static FastNoise fastNoise;

    public ArchFeature(Codec<SimpleBlockProviderConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockProviderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (SimpleBlockProviderConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, SimpleBlockProviderConfig config) {
        this.setSeed(world.m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        int curveLength = 10;
        boolean zAxis = random.nextInt(2) == 0;
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos();
        float curviness = Mth.m_14179_((float)random.nextFloat(), (float)0.05f, (float)0.4f);
        for (int z = -curveLength; z <= curveLength; ++z) {
            mutable2.m_122178_(mutable.m_123341_() + (!zAxis ? z : 0), 0, mutable.m_123343_() + (zAxis ? z : 0));
            int height = ArchFeature.getArchHeight(z, curviness);
            mutable2.m_122175_(Direction.UP, height + pos.m_123342_() + 15);
            int worldHeight = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, mutable2.m_123341_(), mutable2.m_123343_());
            if (worldHeight - 5 >= mutable2.m_123342_()) continue;
            FeaturePlaceContext featurePlaceContext = new FeaturePlaceContext(Optional.empty(), world, chunkGenerator, random, (BlockPos)mutable2, (FeatureConfiguration)new NoisySphereConfig.Builder().setBlock((BlockStateProvider)new WeightedStateProvider(new SimpleWeightedRandomList.Builder().m_146271_((Object)Blocks.f_50352_.m_49966_(), 5).m_146271_((Object)BYGBlocks.RED_ROCK.m_49966_(), 5))).setMinXRadius(4).setMaxXRadius(7).setMinZRadius(4).setMaxZRadius(7).setMinYRadius(7).setMaxYRadius(10).build());
            BYGFeatures.NOISY_SPHERE.m_142674_(featurePlaceContext);
            if (z != -curveLength && z != curveLength) continue;
            while (mutable2.m_123342_() > worldHeight - 5) {
                BYGFeatures.NOISY_SPHERE.m_142674_(featurePlaceContext);
                mutable2.m_122175_(Direction.DOWN, 3);
            }
        }
        return true;
    }

    public static int getArchHeight(int z, float curviness) {
        return (int)((float)(-z * z) * curviness);
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }
}

