/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.nether.warpeddesert;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import potionstudios.byg.common.world.feature.config.WhitelistedSimpleBlockProviderConfig;

public class WarpedCoralFeature
extends Feature<WhitelistedSimpleBlockProviderConfig> {
    public WarpedCoralFeature(Codec<WhitelistedSimpleBlockProviderConfig> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<WhitelistedSimpleBlockProviderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (WhitelistedSimpleBlockProviderConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel worldIn, ChunkGenerator generator, Random rand, BlockPos pos, WhitelistedSimpleBlockProviderConfig config) {
        int randCoralHeight = rand.nextInt(7) + 8;
        if (!this.checkArea((LevelAccessor)worldIn, pos, rand, config)) {
            return false;
        }
        if (config.getWhitelist().contains(worldIn.m_8055_(pos.m_7495_()).m_60734_())) {
            for (int i = 0; i <= randCoralHeight; ++i) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
                this.placeCoral(worldIn, (BlockPos)mutable, rand, config);
                this.placeCoral(worldIn, (BlockPos)mutable.m_122175_(Direction.UP, i), rand, config);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.placeCoral(worldIn, mutable.m_5484_(direction, i / 2), rand, config);
                }
            }
        }
        return true;
    }

    private void placeCoral(WorldGenLevel world, BlockPos pos, Random rand, WhitelistedSimpleBlockProviderConfig config) {
        if (world.m_46859_(pos)) {
            world.m_7731_(pos, config.getBlockProvider().m_7112_(rand, pos), 2);
        }
    }

    private boolean checkArea(LevelAccessor world, BlockPos pos, Random rand, WhitelistedSimpleBlockProviderConfig config) {
        int posX = pos.m_123341_();
        int posY = pos.m_123342_();
        int posZ = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int checkX = -2; checkX <= 2; ++checkX) {
            for (int checkZ = -2; checkZ <= 2; ++checkZ) {
                mutable.m_122178_(posX + checkX, posY, posZ + checkZ);
                if (!world.m_46859_((BlockPos)mutable)) {
                    return false;
                }
                if (world.m_8055_((BlockPos)mutable) != config.getBlockProvider().m_7112_(rand, (BlockPos)mutable)) continue;
                return false;
            }
        }
        return true;
    }
}

