/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.nether.spike;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.common.world.feature.config.SimpleBlockProviderConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class SpikeFeature
extends Feature<SimpleBlockProviderConfig> {
    FastNoise fnPerlin = null;

    public SpikeFeature(Codec<SimpleBlockProviderConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockProviderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (SimpleBlockProviderConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, Random rand, BlockPos pos, SimpleBlockProviderConfig config) {
        this.setSeed(world.m_7328_());
        if (world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76296_ || world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76305_ || world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76307_ || world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()) < 4) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double baseRadius = 4.0;
        int height = 45;
        int startHeight = height - 5;
        for (double y = (double)(-height); y <= -1.0; y += 1.0) {
            for (double x = (double)(-height); x <= (double)height; x += 1.0) {
                for (double z = (double)(-height); z <= (double)height; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y + startHeight, (int)z);
                    double noise = this.fnPerlin.GetNoise(mutable.m_123341_(), mutable.m_123343_()) * 12.0f;
                    double scaledNoise = noise / 11.0 * (-(y * baseRadius) / (x * x + z * z));
                    double threshold = 0.5;
                    if (y == (double)(-height) && scaledNoise >= threshold && world.m_8055_(mutable.m_142300_(Direction.DOWN)).m_60767_() == Material.f_76296_) {
                        return false;
                    }
                    if (!(scaledNoise >= threshold) || world.m_8055_((BlockPos)mutable).m_60767_() != Material.f_76296_) continue;
                    BlockState blockState = config.getBlockProvider().m_7112_(rand, (BlockPos)mutable);
                    world.m_7731_((BlockPos)mutable, blockState, 2);
                    if (blockState.m_60734_() != Blocks.f_49991_) continue;
                    world.m_186469_((BlockPos)mutable, (Fluid)Fluids.f_76195_, 0);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnPerlin == null) {
            this.fnPerlin = new FastNoise((int)seed);
            this.fnPerlin.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
            this.fnPerlin.SetFractalType(FastNoise.FractalType.FBM);
            this.fnPerlin.SetFrequency(0.2f);
        }
    }
}

