/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.end.purpurpeaks;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.common.world.feature.config.SimpleBlockProviderConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;

public class PurpurPeak
extends Feature<SimpleBlockProviderConfig> {
    FastNoiseLite fnlPerlin = null;

    public PurpurPeak(Codec<SimpleBlockProviderConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockProviderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (SimpleBlockProviderConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, Random rand, BlockPos pos, SimpleBlockProviderConfig config) {
        this.setSeed(world.m_7328_());
        if (world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76296_ || world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76305_ || world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76307_ || world.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) < 4) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double baseRadius = 15.0;
        int peakHeight = 125;
        int peakStartHeight = peakHeight - 5;
        double threshold = 0.5;
        for (double y = (double)(-peakHeight); y <= (double)peakHeight; y += 1.0) {
            for (double x = (double)(-peakHeight); x <= (double)peakHeight; x += 1.0) {
                for (double z = (double)(-peakHeight); z <= (double)peakHeight; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y + peakStartHeight, (int)z);
                    float noise3 = FastNoiseLite.getSpongePerlinValue(this.fnlPerlin.GetNoise(mutable.m_123341_(), mutable.m_123343_()));
                    double scaledNoise = (double)(noise3 / 11.0f) * (-(y * baseRadius) / (x * x + z * z));
                    if (y == (double)(-peakHeight) && scaledNoise >= threshold && world.m_8055_(mutable.m_142300_(Direction.DOWN)).m_60767_() == Material.f_76296_) {
                        return false;
                    }
                    if (!(scaledNoise >= threshold) || !world.m_46859_((BlockPos)mutable)) continue;
                    world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnlPerlin == null) {
            this.fnlPerlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.fnlPerlin.SetFrequency(0.2f);
        }
    }
}

