/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.end.islands;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import potionstudios.byg.common.world.feature.config.FloatingIslandConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;

public class FloatingIslands5
extends Feature<FloatingIslandConfig> {
    FastNoiseLite perlin = null;

    public FloatingIslands5(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FloatingIslandConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (FloatingIslandConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        double scaledNoise;
        double noise;
        double z;
        double y;
        double x;
        this.setSeed(world.m_7328_());
        if (world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()) > 4) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        double radius = 25.0;
        double radiusFifth = radius / 5.0;
        for (x = -radiusFifth - 5.0; x <= radiusFifth + 5.0; x += 1.0) {
            for (y = 1.0; y <= radiusFifth + 11.0; y += 1.0) {
                for (z = -radiusFifth - 5.0; z <= radiusFifth + 5.0; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y + 6, (int)z);
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_()));
                    scaledNoise = noise * (Math.pow(y / 2.0, 2.0) / (Math.pow(x, 2.0) + Math.pow(z, 2.0)));
                    if (!(scaledNoise <= 0.5)) continue;
                    world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -radius - 2.0; x <= radius + 2.0; x += 1.0) {
            for (y = 1.0; y <= radius + 11.0; y += 1.0) {
                for (z = -radius - 2.0; z <= radius + 2.0; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y - 22, (int)z);
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_()));
                    scaledNoise = noise * (Math.pow(y / 4.0, 2.0) / (Math.pow(x, 2.0) + Math.pow(z, 2.0)));
                    if (!(scaledNoise >= 0.5)) continue;
                    if (y == 36.0) {
                        world.m_7731_((BlockPos)mutable, config.getTopBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                        continue;
                    }
                    world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -radiusFifth - 2.0; x <= radiusFifth + 2.0; x += 1.0) {
            for (y = 1.0; y <= radiusFifth + 11.0; y += 1.0) {
                for (z = -radiusFifth - 2.0; z <= radiusFifth + 2.0; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y + 5, (int)z);
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_()));
                    scaledNoise = noise * (Math.pow(y / 2.0, 2.0) / (Math.pow(x, 2.0) + Math.pow(z, 2.0)));
                    if (!(scaledNoise >= 0.5)) continue;
                    world.m_7731_((BlockPos)mutable, Blocks.f_50016_.m_49966_(), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

