/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.end.islands;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.common.world.feature.config.FloatingIslandConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;

public class FloatingIslands2
extends Feature<FloatingIslandConfig> {
    FastNoiseLite perlin = null;

    public FloatingIslands2(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FloatingIslandConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (FloatingIslandConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        double noise;
        double z;
        double y;
        double x;
        this.setSeed(world.m_7328_());
        double radius = 15.0;
        double halfRadius = radius / 2.0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()) > 4) {
            return false;
        }
        for (x = -halfRadius - 8.0; x <= halfRadius + 8.0; x += 1.0) {
            for (y = -radius - 2.0; y <= radius; y += 1.0) {
                for (z = -halfRadius - 8.0; z <= halfRadius + 8.0; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y, (int)z);
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_()));
                    double distanceSqt1 = x * x + y * y + z * z + noise * noise;
                    if (!(distanceSqt1 <= halfRadius * radius) || world.m_8055_((BlockPos)mutable).m_60767_() != Material.f_76296_) continue;
                    if (y == radius) {
                        world.m_7731_((BlockPos)mutable, config.getTopBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                        continue;
                    }
                    world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -radius - 8.0; x <= radius + 8.0; x += 1.0) {
            for (y = 1.0; y <= radius + 11.0; y += 1.0) {
                for (z = -radius - 8.0; z <= radius + 8.0; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y - 22, (int)z);
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_()));
                    double scaledNoise = noise * (y * 3.0 / (x * x + z * z));
                    if (!(scaledNoise >= 0.5)) continue;
                    if (y == 26.0) {
                        world.m_7731_((BlockPos)mutable, config.getTopBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                        continue;
                    }
                    world.m_7731_((BlockPos)mutable, config.getBlockProvider().m_7112_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

