/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class PointyRockConfig
implements FeatureConfiguration {
    public static final Codec<PointyRockConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)Codec.INT.fieldOf("seed").orElse((Object)0).forGetter(config -> config.seed), (App)Codec.DOUBLE.fieldOf("height_multiplier").orElse((Object)1.0).forGetter(config -> config.heightMultiplier)).apply((Applicative)codecRecorder, PointyRockConfig::new));
    private final BlockStateProvider blockProvider;
    private final int seed;
    private final double heightMultiplier;
    private FastNoise noiseGen = null;

    PointyRockConfig(BlockStateProvider blockProvider, int seed, double heightMultiplier) {
        this.blockProvider = blockProvider;
        this.seed = seed;
        this.heightMultiplier = heightMultiplier;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public int getSeed() {
        return this.seed;
    }

    public double getHeightMultiplier() {
        return this.heightMultiplier;
    }

    public void setUpNoise(long worldSeed) {
        if (this.noiseGen == null) {
            this.noiseGen = new FastNoise((int)(worldSeed + (long)this.seed));
            this.noiseGen.SetFractalType(FastNoise.FractalType.RigidMulti);
            this.noiseGen.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.noiseGen.SetGradientPerturbAmp(5.0f);
            this.noiseGen.SetFractalOctaves(1);
            this.noiseGen.SetFractalGain(0.3f);
            this.noiseGen.SetFrequency(0.02f);
        }
    }

    public FastNoise getNoiseGen() {
        if (this.noiseGen == null) {
            throw new NullPointerException("Initialize the noiseGen variable with \"setupNoise\" in your feature!");
        }
        return this.noiseGen;
    }

    public static class Builder {
        private BlockStateProvider blockProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
        private int seed = 65;
        private double heightMultiplier = 1.0;

        public Builder setBlock(Block block) {
            this.blockProvider = SimpleStateProvider.m_191384_((BlockState)block.m_49966_());
            return this;
        }

        public Builder setBlock(BlockState state) {
            this.blockProvider = SimpleStateProvider.m_191384_((BlockState)state);
            return this;
        }

        public Builder setBlock(BlockStateProvider blockProvider) {
            this.blockProvider = blockProvider;
            return this;
        }

        public Builder setSeed(int seed) {
            this.seed = seed;
            return this;
        }

        public Builder setHeightMultiplier(double heightMultiplier) {
            this.heightMultiplier = heightMultiplier;
            return this;
        }

        public PointyRockConfig build() {
            return new PointyRockConfig(this.blockProvider, this.seed, this.heightMultiplier);
        }
    }
}

