/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;

public class FloatingIslandConfig
implements FeatureConfiguration {
    public static final Codec<FloatingIslandConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("top_block_provider").forGetter(config -> config.topBlockProvider), (App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)Codec.INT.fieldOf("min_radius").orElse((Object)13).forGetter(config -> config.minRadius), (App)Codec.INT.fieldOf("max_radius").orElse((Object)15).forGetter(config -> config.maxRadius)).apply((Applicative)codecRecorder, FloatingIslandConfig::new));
    private final BlockStateProvider topBlockProvider;
    private final BlockStateProvider blockProvider;
    private final int minRadius;
    private final int maxRadius;

    FloatingIslandConfig(BlockStateProvider topBlockProvider, BlockStateProvider blockProvider, int minRadius, int maxRadius) {
        this.topBlockProvider = topBlockProvider;
        this.blockProvider = blockProvider;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public BlockStateProvider getTopBlockProvider() {
        return this.topBlockProvider;
    }

    public int getMinRadius() {
        return Math.abs(this.minRadius);
    }

    public int getMaxRadius() {
        return Math.abs(this.maxRadius);
    }

    public int getMaxPossibleRadius() {
        int returnValue = this.maxRadius - this.minRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public static class Builder {
        private BlockStateProvider topBlockProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50440_.m_49966_());
        private BlockStateProvider blockProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
        private int minRadius = 1;
        private int maxRadius = 3;

        public Builder setTopBlock(Block block) {
            this.topBlockProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setTopBlock(BlockState state) {
            this.topBlockProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setTopBlock(BlockStateProvider provider) {
            this.topBlockProvider = provider != null ? provider : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setBlock(Block block) {
            this.blockProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setBlock(BlockState state) {
            this.blockProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setBlock(BlockStateProvider provider) {
            this.blockProvider = provider != null ? provider : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setMinRadius(int minRadius) {
            this.minRadius = minRadius <= 0 ? 1 : minRadius;
            return this;
        }

        public Builder setMaxRadius(int maxRadius) {
            this.maxRadius = maxRadius <= 0 ? this.minRadius + 1 : maxRadius;
            return this;
        }

        public Builder copy(FloatingIslandConfig config) {
            this.topBlockProvider = config.topBlockProvider;
            this.blockProvider = config.blockProvider;
            this.minRadius = config.minRadius;
            this.maxRadius = config.maxRadius;
            return this;
        }

        public FloatingIslandConfig build() {
            return new FloatingIslandConfig(this.topBlockProvider, this.blockProvider, this.minRadius, this.maxRadius);
        }
    }
}

