/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import potionstudios.byg.common.block.BYGBlocks;

public class BrimstoneVentsConfig
implements FeatureConfiguration {
    public static final Codec<BrimstoneVentsConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)BlockStateProvider.f_68747_.fieldOf("lava_provider").forGetter(config -> config.lavaProvider)).apply((Applicative)codecRecorder, BrimstoneVentsConfig::new));
    private final BlockStateProvider blockProvider;
    private final BlockStateProvider lavaProvider;

    BrimstoneVentsConfig(BlockStateProvider blockProvider, BlockStateProvider lavaProvider) {
        this.blockProvider = blockProvider;
        this.lavaProvider = lavaProvider;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public BlockStateProvider getLavaProvider() {
        return this.lavaProvider;
    }

    public static class Builder {
        private BlockStateProvider blockProvider = SimpleStateProvider.m_191384_((BlockState)BYGBlocks.BRIMSTONE.m_49966_());
        private BlockStateProvider lavaProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_49991_.m_49966_());

        public Builder setBlock(Block block) {
            this.blockProvider = SimpleStateProvider.m_191384_((BlockState)block.m_49966_());
            return this;
        }

        public Builder setBlock(BlockState state) {
            this.blockProvider = SimpleStateProvider.m_191384_((BlockState)state);
            return this;
        }

        public Builder setLavaBlock(Block block) {
            this.lavaProvider = SimpleStateProvider.m_191384_((BlockState)block.m_49966_());
            return this;
        }

        public Builder setLavaBlock(BlockState state) {
            this.lavaProvider = SimpleStateProvider.m_191384_((BlockState)state);
            return this;
        }

        public BrimstoneVentsConfig build() {
            return new BrimstoneVentsConfig(this.blockProvider, this.lavaProvider);
        }
    }
}

