/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class Column
extends Feature<NoisySphereConfig> {
    protected static FastNoise fastNoise;
    protected long seed;

    public Column(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoisySphereConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (NoisySphereConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoisySphereConfig config) {
        this.setSeed(world.m_7328_());
        boolean use2D = random.nextInt(5) == 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position.m_6625_(2 + random.nextInt(10)));
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable);
        int xRadius = config.getRandomXRadius(random);
        int yRadius = config.getRandomYRadius(random) * 2 + 10;
        int zRadius = config.getRandomZRadius(random);
        for (int stackIDX = 0; stackIDX < 2; ++stackIDX) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                float xFract = (float)x / (float)xRadius;
                for (int z = -zRadius; z <= zRadius; ++z) {
                    float zFract = (float)z / (float)zRadius;
                    for (int y = -yRadius; y <= yRadius + 15; ++y) {
                        float yFract = (float)y / (float)yRadius;
                        mutable2.m_122190_((Vec3i)mutable).m_122184_(x, y, z);
                        float distanceSquaredFromCenter = xFract * xFract + yFract * yFract + zFract * zFract;
                        float yDistSquared = yFract * yFract;
                        float noise = use2D ? fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123343_()) : fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123342_(), mutable2.m_123343_());
                        float threshold = 1.0f + 0.7f * noise;
                        float factor = yDistSquared / threshold;
                        if (factor >= 1.0f) {
                            distanceSquaredFromCenter /= factor;
                            distanceSquaredFromCenter = (float)((double)distanceSquaredFromCenter - Math.copySign((double)noise * 0.2, (double)distanceSquaredFromCenter));
                        }
                        if (distanceSquaredFromCenter >= threshold) continue;
                        world.m_7731_((BlockPos)mutable2, config.getTopBlockProvider().m_7112_(random, (BlockPos)mutable2), 2);
                        world.m_7731_((BlockPos)mutable2.m_122173_(Direction.DOWN), config.getBlockProvider().m_7112_(random, (BlockPos)mutable2), 2);
                    }
                }
            }
            xRadius = (int)((double)xRadius / config.getRadiusDivisorPerStack());
            yRadius = (int)((float)yRadius * 0.1f);
            mutable.m_142448_(mutable.m_123342_() + yRadius);
            zRadius = (int)((double)zRadius / config.getRadiusDivisorPerStack());
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Cellular);
            fastNoise.SetFrequency(0.09f);
            this.seed = seed;
        }
    }
}

