/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.feature.BYGConfiguredFeatures;
import potionstudios.byg.mixin.access.VegetationPlacementsAccess;

public class BYGPlacedFeatures {
    public static final PlacedFeature ALLIUM_FIELD_FLOWERS = BYGPlacedFeatures.createPlacedFeature("allium_field_flowers", BYGConfiguredFeatures.ALLIUM_FIELD_FLOWERS.m_190821_(VegetationPlacements.m_195474_((int)20)));
    public static final PlacedFeature AMARANTH_FIELD_FLOWERS = BYGPlacedFeatures.createPlacedFeature("amaranth_field_flowers", BYGConfiguredFeatures.AMARANTH_FIELD_FLOWERS.m_190821_(VegetationPlacements.m_195474_((int)20)));
    public static final PlacedFeature FIRECRACKER_BUSH = BYGPlacedFeatures.createPlacedFeature("firecracker_bush", BYGConfiguredFeatures.FIRECRACKER_BUSH.m_190821_(VegetationPlacements.m_195474_((int)3)));
    public static final PlacedFeature BLUE_BERRY_BUSH = BYGPlacedFeatures.createPlacedFeature("blue_berry_bush", BYGConfiguredFeatures.BYG_GRASS_EXTRA.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature BLUE_BERRY_BUSH_LUSH = BYGPlacedFeatures.createPlacedFeature("blue_berry_bush_lush", BYGConfiguredFeatures.BYG_GRASS_EXTRA.m_190821_(VegetationPlacements.m_195474_((int)5)));
    public static final PlacedFeature CATTAIL = BYGPlacedFeatures.createPlacedFeature("cattails", BYGConfiguredFeatures.CATTAIL.m_190821_(BYGPlacedFeatures.oceanFloorSquaredWithCountAndMaxDepth(25, OptionalInt.of(2))));
    public static final PlacedFeature LEATHER_FLOWERS = BYGPlacedFeatures.createPlacedFeature("leather_flowers", BYGConfiguredFeatures.LEATHER_FLOWERS.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature LEAF_PILES = BYGPlacedFeatures.createPlacedFeature("leaf_piles", BYGConfiguredFeatures.LEAF_PILE.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature CLOVER_FLOWERS = BYGPlacedFeatures.createPlacedFeature("clover_flower_patch", BYGConfiguredFeatures.CLOVER_PATCH.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature CROCUS = BYGPlacedFeatures.createPlacedFeature("crocus", BYGConfiguredFeatures.CROCUS.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature ANEMONES = BYGPlacedFeatures.createPlacedFeature("anemones", BYGConfiguredFeatures.ANEMONES.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature ROSES = BYGPlacedFeatures.createPlacedFeature("rose", BYGConfiguredFeatures.ROSE.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature BLACK_ROSE = BYGPlacedFeatures.createPlacedFeature("black_rose", BYGConfiguredFeatures.BLACK_ROSE.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature CYAN_ROSE = BYGPlacedFeatures.createPlacedFeature("cyan_rose", BYGConfiguredFeatures.CYAN_ROSE.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature DAISY_ORANGE = BYGPlacedFeatures.createPlacedFeature("orange_daisy", BYGConfiguredFeatures.DAISY_ORANGE.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature JAPANESE_ORCHID = BYGPlacedFeatures.createPlacedFeature("japanese_orchid", BYGConfiguredFeatures.JAPANESE_ORCHID.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature FAIRY_SLIPPER = BYGPlacedFeatures.createPlacedFeature("fairy_slipper", BYGConfiguredFeatures.FAIRY_SLIPPER.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature CHERRY_FOLIAGE = BYGPlacedFeatures.createPlacedFeature("cherry_foliage", BYGConfiguredFeatures.CHERRY_FOLIAGE.m_190821_(VegetationPlacements.m_195474_((int)6)));
    public static final PlacedFeature HORSEWEED = BYGPlacedFeatures.createPlacedFeature("horseweed", BYGConfiguredFeatures.HORSEWEED.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature IRIS = BYGPlacedFeatures.createPlacedFeature("iris", BYGConfiguredFeatures.IRIS.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature TULIPS = BYGPlacedFeatures.createPlacedFeature("tulips", BYGConfiguredFeatures.TULIPS.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature WHITE_PUFFBALL = BYGPlacedFeatures.createPlacedFeature("white_puffball", BYGConfiguredFeatures.WHITE_PUFFBALL.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature SAGES = BYGPlacedFeatures.createPlacedFeature("sages", BYGConfiguredFeatures.SAGES.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature WINTER_SUCCULENT = BYGPlacedFeatures.createPlacedFeature("winter_succulent", BYGConfiguredFeatures.WINTER_SUCCULENT.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature DAFFODIL_YELLOW = BYGPlacedFeatures.createPlacedFeature("yellow_daffodil", BYGConfiguredFeatures.DAFFODIL_YELLOW.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature JUNGLE_FLOWERS = BYGPlacedFeatures.createPlacedFeature("jungle_flowers", BYGConfiguredFeatures.JUNGLE_FLOWERS.m_190821_(VegetationPlacements.m_195474_((int)2)));
    public static final PlacedFeature LARGE_PUMPKINS = BYGPlacedFeatures.createPlacedFeature("large_pumpkins", BYGConfiguredFeatures.LARGE_PUMPKINS.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.25f, (int)1))));
    public static final PlacedFeature SWAMP_WATER_VEGETATION = BYGPlacedFeatures.createPlacedFeature("swamp_water_vegetation", BYGConfiguredFeatures.SWAMP_WATER_VEGETATION.m_190821_(VegetationPlacements.m_195474_((int)25)));
    public static final PlacedFeature MUSHROOMS = BYGPlacedFeatures.createPlacedFeature("mushrooms", BYGConfiguredFeatures.MUSHROOMS.m_190821_(VegetationPlacementsAccess.invokeGetMushroomPlacement(512, null)));
    public static final PlacedFeature ARAUCARIA_TREES = BYGPlacedFeatures.createPlacedFeature("araucaria_trees", BYGConfiguredFeatures.ARAUCARIA_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.25f, (int)2))));
    public static final PlacedFeature ASPEN_SHRUBS = BYGPlacedFeatures.createPlacedFeature("aspen_shrubs", BYGConfiguredFeatures.ASPEN_SHRUBS.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)2))));
    public static final PlacedFeature ASPEN_TREES = BYGPlacedFeatures.createPlacedFeature("aspen_trees", BYGConfiguredFeatures.ASPEN_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)6, (float)0.25f, (int)3))));
    public static final PlacedFeature ASPEN_TREES_SPARSE = BYGPlacedFeatures.createPlacedFeature("aspen_trees_sparse", BYGConfiguredFeatures.ASPEN_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)1))));
    public static final PlacedFeature BAOBAB_TREES = BYGPlacedFeatures.createPlacedFeature("baobab_trees", BYGConfiguredFeatures.BAOBAB_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)1))));
    public static final PlacedFeature BOREAL_TREES = BYGPlacedFeatures.createPlacedFeature("boreal_trees", BYGConfiguredFeatures.BOREAL_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)4, (float)0.2f, (int)2))));
    public static final PlacedFeature BAYOU_TREES = BYGPlacedFeatures.createPlacedFeature("bayou_trees", BYGConfiguredFeatures.BAYOU_TREES.m_190821_(BYGPlacedFeatures.treePlacementBaseOceanFloor(PlacementUtils.m_195364_((int)4, (float)0.2f, (int)2))));
    public static final PlacedFeature BLACK_FOREST_TREES = BYGPlacedFeatures.createPlacedFeature("black_forest_trees", BYGConfiguredFeatures.BLACK_FOREST_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)8, (float)0.2f, (int)2))));
    public static final PlacedFeature CANADIAN_SHIELD_TREES = BYGPlacedFeatures.createPlacedFeature("canadian_shield_trees", BYGConfiguredFeatures.CANADIAN_SHIELD_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)4, (float)0.25f, (int)2))));
    public static final PlacedFeature CHERRY_TREES = BYGPlacedFeatures.createPlacedFeature("cherry_trees", BYGConfiguredFeatures.CHERRY_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)6, (float)0.25f, (int)2))));
    public static final PlacedFeature CIKA_TREES = BYGPlacedFeatures.createPlacedFeature("cika_trees", BYGConfiguredFeatures.CIKA_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)2, (float)0.25f, (int)2))));
    public static final PlacedFeature CONIFER_TREES = BYGPlacedFeatures.createPlacedFeature("conifer_trees", BYGConfiguredFeatures.CONIFER_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)7, (float)0.25f, (int)3))));
    public static final PlacedFeature CYPRESS_TREES = BYGPlacedFeatures.createPlacedFeature("cypress_trees", BYGConfiguredFeatures.CYPRESS_TREES.m_190821_(BYGPlacedFeatures.treePlacementBaseOceanFloor(PlacementUtils.m_195364_((int)4, (float)0.25f, (int)1))));
    public static final PlacedFeature DACITE_RIDGE_TREES = BYGPlacedFeatures.createPlacedFeature("dacite_ridge_trees", BYGConfiguredFeatures.DACITE_RIDGE_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.25f, (int)2))));
    public static final PlacedFeature DECIDUOUS_TREES = BYGPlacedFeatures.createPlacedFeature("deciduous_trees", BYGConfiguredFeatures.DECIDUOUS_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)3, (float)0.25f, (int)2))));
    public static final PlacedFeature EBONY_TREES = BYGPlacedFeatures.createPlacedFeature("ebony_trees", BYGConfiguredFeatures.EBONY_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)4, (float)0.25f, (int)4))));
    public static final PlacedFeature ENCHANTED_TREES = BYGPlacedFeatures.createPlacedFeature("enchanted_trees", BYGConfiguredFeatures.ENCHANTED_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)5, (float)0.2f, (int)2))));
    public static final PlacedFeature TEMPERATE_GROVE_TREES = BYGPlacedFeatures.createPlacedFeature("temperate_grove_trees", BYGConfiguredFeatures.TEMPERATE_GROVE_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.25f, (int)2))));
    public static final PlacedFeature JACARANDA_TREES = BYGPlacedFeatures.createPlacedFeature("jacaranda_trees", BYGConfiguredFeatures.JACARANDA_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)4, (float)0.2f, (int)2))));
    public static final PlacedFeature JACARANDA_BUSHES = BYGPlacedFeatures.createPlacedFeature("jacaranda_bushes", BYGConfiguredFeatures.JACARANDA_BUSHES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.2f, (int)1))));
    public static final PlacedFeature MANGROVE_TREES = BYGPlacedFeatures.createPlacedFeature("mangrove_trees", BYGConfiguredFeatures.MANGROVE_TREES.m_190821_(BYGPlacedFeatures.treePlacementBaseOceanFloor(PlacementUtils.m_195364_((int)6, (float)0.25f, (int)2))));
    public static final PlacedFeature MAPLE_TREES = BYGPlacedFeatures.createPlacedFeature("maple_trees", BYGConfiguredFeatures.MAPLE_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)4, (float)0.25f, (int)2))));
    public static final PlacedFeature HOLLY_TREES = BYGPlacedFeatures.createPlacedFeature("holly_trees", BYGConfiguredFeatures.HOLLY_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)4, (float)0.25f, (int)4))));
    public static final PlacedFeature PRAIRIE_SHRUBS = BYGPlacedFeatures.createPlacedFeature("prairie_shrubs", BYGConfiguredFeatures.DECIDUOUS_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)2))));
    public static final PlacedFeature RAINFOREST_TREES = BYGPlacedFeatures.createPlacedFeature("rainforest_trees", BYGConfiguredFeatures.RAINFOREST_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)15, (float)0.25f, (int)1))));
    public static final PlacedFeature SPRUCE_TREES_SPARSE = BYGPlacedFeatures.createPlacedFeature("spruce_trees_sparse", BYGConfiguredFeatures.SPRUCE_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.2f, (int)1))));
    public static final PlacedFeature HUGE_MUSHROOMS = BYGPlacedFeatures.createPlacedFeature("huge_mushrooms", BYGConfiguredFeatures.HUGE_MUSHROOMS.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)2))));
    public static final PlacedFeature MEADOW_SHRUBS = BYGPlacedFeatures.createPlacedFeature("meadow_shrubs", BYGConfiguredFeatures.MEADOW_SHRUBS.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.25f, (int)2))));
    public static final PlacedFeature SPARSE_RED_OAK_TREES = BYGPlacedFeatures.createPlacedFeature("sparse_red_oak_trees", BYGConfiguredFeatures.RED_OAK_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.2f, (int)1))));
    public static final PlacedFeature SPARSE_JACARANDA_TREES = BYGPlacedFeatures.createPlacedFeature("sparse_jacaranda_trees", BYGConfiguredFeatures.JACARANDA_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.2f, (int)2))));
    public static final PlacedFeature SPARSE_ARAUCARIA_TREES = BYGPlacedFeatures.createPlacedFeature("sparse_araucaria_trees", BYGConfiguredFeatures.ARAUCARIA_TREES.m_190821_(VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)0.2f, (int)3))));
    public static final PlacedFeature DISK_MUD = BYGPlacedFeatures.createPlacedFeature("disk_mud", BYGConfiguredFeatures.DISK_MUD.m_190823_(new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature MOSSY_STONE_BOULDER = BYGPlacedFeatures.createPlacedFeature("mossy_stone_boulder", BYGConfiguredFeatures.MOSSY_STONE_BOULDER.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature ROCKY_STONE_BOULDER = BYGPlacedFeatures.createPlacedFeature("rocky_stone_boulder", BYGConfiguredFeatures.ROCKY_STONE_BOULDER.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature BLACKSTONE_BOULDER = BYGPlacedFeatures.createPlacedFeature("blackstone_boulder", BYGConfiguredFeatures.BLACKSTONE_BOULDER.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature ORANGE_TERRACOTTA_BOULDER = BYGPlacedFeatures.createPlacedFeature("orange_terracotta_boulder", BYGConfiguredFeatures.ORANGE_TERRACOTTA_BOULDER.m_190823_(new PlacementModifier[]{CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()}));
    public static final PlacedFeature DEAD_SEA_SPIKES = BYGPlacedFeatures.createPlacedFeature("dead_sea_spikes", BYGConfiguredFeatures.DEAD_SEA_SPIKES.m_190821_(BYGPlacedFeatures.oceanFloorSquaredWithCount(3)));

    private static List<PlacementModifier> treePlacementBaseOceanFloor(PlacementModifier $$0) {
        return ImmutableList.builder().add((Object)$$0).add((Object)InSquarePlacement.m_191715_()).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_()).build();
    }

    public static List<PlacementModifier> oceanFloorSquaredWithCount(int $$0) {
        return BYGPlacedFeatures.oceanFloorSquaredWithCountAndMaxDepth($$0, OptionalInt.empty());
    }

    public static List<PlacementModifier> oceanFloorSquaredWithCountAndMaxDepth(int $$0, OptionalInt maxDepth) {
        ArrayList<BiomeFilter> placementModifiers = new ArrayList<BiomeFilter>(List.of(CountPlacement.m_191628_((int)$$0), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, BiomeFilter.m_191561_()));
        if (maxDepth.isPresent()) {
            placementModifiers.add((BiomeFilter)SurfaceWaterDepthFilter.m_191950_((int)maxDepth.getAsInt()));
        }
        return placementModifiers;
    }

    public static <PF extends PlacedFeature> PF createPlacedFeature(String id, PF placedFeature) {
        ResourceLocation bygID = BYG.createLocation(id);
        if (BuiltinRegistries.f_194653_.m_6566_().contains(bygID)) {
            throw new IllegalStateException("Placed Feature ID: \"" + bygID.toString() + "\" already exists in the Placed Features registry!");
        }
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)bygID, placedFeature);
        return placedFeature;
    }
}

