/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import potionstudios.byg.common.world.biome.BYGBiomes;
import potionstudios.byg.util.BYGUtil;
import potionstudios.byg.util.CodecUtil;

public class BYGOverworldBiomeBuilder {
    private static final ResourceKey<Biome>[][] OCEANS_EMPTY = new ResourceKey[][]{{Biomes.f_48172_, Biomes.f_48171_, Biomes.f_48225_, Biomes.f_48170_, Biomes.f_48166_}, {Biomes.f_48211_, Biomes.f_48168_, Biomes.f_48174_, Biomes.f_48167_, Biomes.f_48166_}};
    private static final ResourceKey<Biome>[][] MIDDLE_BIOMES_EMPTY = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48206_}, {Biomes.f_48202_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48206_, Biomes.f_186764_}, {Biomes.f_48179_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48151_}, {Biomes.f_48157_, Biomes.f_48157_, Biomes.f_48205_, Biomes.f_48222_, Biomes.f_48222_}, {Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_}};
    private static final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT_EMPTY = new ResourceKey[][]{{Biomes.f_48182_, Biomes.f_48173_, Biomes.f_48152_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_186763_}, {Biomes.f_48176_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_186762_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48202_, Biomes.f_186769_, Biomes.f_48197_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}};
    private static final ResourceKey<Biome>[][] PLATEAU_BIOMES_EMPTY = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48205_, Biomes.f_48206_, Biomes.f_186764_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48151_}, {Biomes.f_48158_, Biomes.f_48158_, Biomes.f_48205_, Biomes.f_48205_, Biomes.f_48222_}, {Biomes.f_48159_, Biomes.f_48159_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}};
    private static final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT_EMPTY = new ResourceKey[][]{{Biomes.f_48182_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186763_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48194_, Biomes.f_48194_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}};
    private static final ResourceKey<Biome>[][] EXTREME_HILLS_EMPTY = new ResourceKey[][]{{Biomes.f_186766_, Biomes.f_186766_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_186766_, Biomes.f_186766_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}};
    private static final ResourceKey<Biome>[][] OCEANS = new ResourceKey[][]{{Biomes.f_48172_, Biomes.f_48171_, Biomes.f_48225_, Biomes.f_48170_, Biomes.f_48166_}, {Biomes.f_48211_, Biomes.f_48168_, Biomes.f_48174_, Biomes.f_48167_, BYGBiomes.DEAD_SEA}};
    private static final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48206_}, {Biomes.f_48202_, Biomes.f_48202_, Biomes.f_48205_, BYGBiomes.AUTUMNAL_VALLEY, Biomes.f_186764_}, {Biomes.f_48179_, Biomes.f_48202_, BYGBiomes.ALLIUM_FIELDS, Biomes.f_48149_, Biomes.f_48151_}, {Biomes.f_48157_, BYGBiomes.BAOBAB_SAVANNA, BYGBiomes.CHERRY_BLOSSOM_FOREST, BYGBiomes.EBONY_WOODS, BYGBiomes.JACARANDA_FOREST}, {Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_}};
    private static final ResourceKey<Biome>[][] MIDDLE_BIOMES_2 = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48206_}, {Biomes.f_48202_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48206_, Biomes.f_186764_}, {Biomes.f_48179_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48151_}, {Biomes.f_48157_, Biomes.f_48157_, BYGBiomes.FORGOTTEN_FOREST, Biomes.f_48222_, Biomes.f_48222_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}};
    private static final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48182_, Biomes.f_48173_, Biomes.f_48152_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, BYGBiomes.ASPEN_FOREST, Biomes.f_48173_, Biomes.f_186763_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48173_}, {Biomes.f_48173_, BYGBiomes.ARAUCARIA_SAVANNA, Biomes.f_48173_, BYGBiomes.AMARANTH_FIELDS, Biomes.f_48173_}, {Biomes.f_48194_, Biomes.f_48194_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}};
    private static final ResourceKey<Biome>[][] PLATEAU_BIOMES = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186754_, Biomes.f_186754_, BYGBiomes.MAPLE_TAIGA, BYGBiomes.CANADIAN_SHIELD, BYGBiomes.BLACK_FOREST}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48151_}, {Biomes.f_48158_, Biomes.f_48158_, Biomes.f_48205_, Biomes.f_48205_, Biomes.f_48222_}, {Biomes.f_48159_, Biomes.f_48159_, Biomes.f_48159_, Biomes.f_186753_, BYGBiomes.GUIANA_SHIELD}};
    private static final ResourceKey<Biome>[][] PLATEAU_BIOMES_2 = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186754_, Biomes.f_186754_, BYGBiomes.CONIFEROUS_FOREST, BYGBiomes.CIKA_WOODS, Biomes.f_186764_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48151_}, {Biomes.f_48158_, Biomes.f_48158_, Biomes.f_48205_, Biomes.f_48205_, Biomes.f_48222_}, {Biomes.f_48159_, Biomes.f_48159_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}};
    private static final ResourceKey<Biome>[][] PLATEAU_BIOMES_3 = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48205_, BYGBiomes.DACITE_RIDGES, Biomes.f_186764_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48151_}, {Biomes.f_48158_, Biomes.f_48158_, Biomes.f_48205_, Biomes.f_48205_, Biomes.f_48222_}, {Biomes.f_48159_, Biomes.f_48159_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}};
    private static final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48182_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, BYGBiomes.CONIFEROUS_FOREST, Biomes.f_186754_, BYGBiomes.BOREALIS_GROVE}, {Biomes.f_48173_, Biomes.f_48173_, BYGBiomes.GROVE, Biomes.f_48149_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48194_, Biomes.f_48194_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}};
    private static final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT_2 = new ResourceKey[][]{{Biomes.f_48182_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_186754_, BYGBiomes.MAPLE_TAIGA, Biomes.f_186763_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48194_, Biomes.f_48194_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}};
    private static final ResourceKey<Biome>[][] EXTREME_HILLS = new ResourceKey[][]{{Biomes.f_186766_, Biomes.f_186766_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_186766_, Biomes.f_186766_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}, {Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_, Biomes.f_48173_}};
    public static final List<BiomeProviderData> OVERWORLD_DEFAULTS = (List)Util.m_137469_(new ArrayList(), list -> {
        int overworldWeight = 8;
        list.add(new BiomeProviderData(overworldWeight, OCEANS, MIDDLE_BIOMES, MIDDLE_BIOMES_VARIANT, PLATEAU_BIOMES, PLATEAU_BIOMES_VARIANT, EXTREME_HILLS, (Map<ResourceKey<Biome>, ResourceKey<Biome>>)((Map)Util.m_137469_(new IdentityHashMap(), map -> map.put(Biomes.f_48207_, BYGBiomes.BAYOU)))));
        list.add(new BiomeProviderData(overworldWeight, OCEANS_EMPTY, MIDDLE_BIOMES_2, MIDDLE_BIOMES_VARIANT_EMPTY, PLATEAU_BIOMES_2, PLATEAU_BIOMES_VARIANT_2, EXTREME_HILLS_EMPTY, (Map<ResourceKey<Biome>, ResourceKey<Biome>>)((Map)Util.m_137469_(new IdentityHashMap(), map -> map.put(Biomes.f_48207_, BYGBiomes.CYPRESS_SWAMPLANDS)))));
        list.add(new BiomeProviderData(overworldWeight, OCEANS_EMPTY, MIDDLE_BIOMES_EMPTY, MIDDLE_BIOMES_VARIANT_EMPTY, PLATEAU_BIOMES_3, PLATEAU_BIOMES_VARIANT_EMPTY, EXTREME_HILLS_EMPTY, new IdentityHashMap<ResourceKey<Biome>, ResourceKey<Biome>>()));
    });

    public static final class BiomeProviderData {
        public static final Codec<BiomeProviderData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("weight").forGetter(biomeProviderData -> biomeProviderData.overworldWeight), (App)Codec.list((Codec)Codec.list(CodecUtil.BIOME_CODEC)).fieldOf("oceans").forGetter(biomeProviderData -> BYGUtil.convert2DArray(biomeProviderData.oceans)), (App)Codec.list((Codec)Codec.list(CodecUtil.BIOME_CODEC)).fieldOf("middle_biomes").forGetter(biomeProviderData -> BYGUtil.convert2DArray(biomeProviderData.middleBiomes)), (App)Codec.list((Codec)Codec.list(CodecUtil.BIOME_CODEC)).fieldOf("middle_biomes_variant").forGetter(biomeProviderData -> BYGUtil.convert2DArray(biomeProviderData.middleBiomesVariant)), (App)Codec.list((Codec)Codec.list(CodecUtil.BIOME_CODEC)).fieldOf("plateau_biomes").forGetter(biomeProviderData -> BYGUtil.convert2DArray(biomeProviderData.plateauBiomes)), (App)Codec.list((Codec)Codec.list(CodecUtil.BIOME_CODEC)).fieldOf("plateau_biomes_variant").forGetter(biomeProviderData -> BYGUtil.convert2DArray(biomeProviderData.plateauBiomesVariant)), (App)Codec.list((Codec)Codec.list(CodecUtil.BIOME_CODEC)).fieldOf("extreme_hills").forGetter(biomeProviderData -> BYGUtil.convert2DArray(biomeProviderData.extremeHills)), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_.comapFlatMap(resourceLocation -> {
            if (!resourceLocation.m_135827_().equals("minecraft")) {
                throw new IllegalArgumentException("Only biomes from MC can be used as the swapper's key!!! You put: \"" + resourceLocation.toString() + "\"");
            }
            return DataResult.success((Object)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)resourceLocation));
        }, ResourceKey::m_135782_), CodecUtil.BIOME_CODEC).fieldOf("swapper").forGetter(biomeProviderData -> biomeProviderData.swapper)).apply((Applicative)builder, BiomeProviderData::new));
        private final int overworldWeight;
        private final ResourceKey<Biome>[][] oceans;
        private final ResourceKey<Biome>[][] middleBiomes;
        private final ResourceKey<Biome>[][] middleBiomesVariant;
        private final ResourceKey<Biome>[][] plateauBiomes;
        private final ResourceKey<Biome>[][] plateauBiomesVariant;
        private final ResourceKey<Biome>[][] extremeHills;
        private final Map<ResourceKey<Biome>, ResourceKey<Biome>> swapper;

        public BiomeProviderData(int overworldWeight, List<List<ResourceKey<Biome>>> oceans, List<List<ResourceKey<Biome>>> middleBiomes, List<List<ResourceKey<Biome>>> middleBiomesVariant, List<List<ResourceKey<Biome>>> plateauBiomes, List<List<ResourceKey<Biome>>> plateauBiomesVariant, List<List<ResourceKey<Biome>>> extremeHills, Map<ResourceKey<Biome>, ResourceKey<Biome>> swapper) {
            this(overworldWeight, BYGUtil.convert2DResourceKeyArrayTo2DList(oceans), BYGUtil.convert2DResourceKeyArrayTo2DList(middleBiomes), BYGUtil.convert2DResourceKeyArrayTo2DList(middleBiomesVariant), BYGUtil.convert2DResourceKeyArrayTo2DList(plateauBiomes), BYGUtil.convert2DResourceKeyArrayTo2DList(plateauBiomesVariant), BYGUtil.convert2DResourceKeyArrayTo2DList(extremeHills), swapper);
        }

        public BiomeProviderData(int overworldWeight, ResourceKey<Biome>[][] oceans, ResourceKey<Biome>[][] middleBiomes, ResourceKey<Biome>[][] middleBiomesVariant, ResourceKey<Biome>[][] plateauBiomes, ResourceKey<Biome>[][] plateauBiomesVariant, ResourceKey<Biome>[][] extremeHills, Map<ResourceKey<Biome>, ResourceKey<Biome>> swapper) {
            this.overworldWeight = overworldWeight;
            this.oceans = oceans;
            this.middleBiomes = middleBiomes;
            this.middleBiomesVariant = middleBiomesVariant;
            this.plateauBiomes = plateauBiomes;
            this.plateauBiomesVariant = plateauBiomesVariant;
            this.extremeHills = extremeHills;
            this.swapper = swapper;
        }

        public int overworldWeight() {
            return this.overworldWeight;
        }

        public ResourceKey<Biome>[][] oceans() {
            return this.oceans;
        }

        public ResourceKey<Biome>[][] middleBiomes() {
            return this.middleBiomes;
        }

        public ResourceKey<Biome>[][] middleBiomesVariant() {
            return this.middleBiomesVariant;
        }

        public ResourceKey<Biome>[][] plateauBiomes() {
            return this.plateauBiomes;
        }

        public ResourceKey<Biome>[][] plateauBiomesVariant() {
            return this.plateauBiomesVariant;
        }

        public ResourceKey<Biome>[][] extremeHills() {
            return this.extremeHills;
        }

        public Map<ResourceKey<Biome>, ResourceKey<Biome>> swapper() {
            return this.swapper;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == Biomes.f_48173_ || obj.getClass() != this.getClass()) {
                return false;
            }
            BiomeProviderData that = (BiomeProviderData)obj;
            return this.overworldWeight == that.overworldWeight && Objects.equals(this.oceans, that.oceans) && Objects.equals(this.middleBiomes, that.middleBiomes) && Objects.equals(this.middleBiomesVariant, that.middleBiomesVariant) && Objects.equals(this.plateauBiomes, that.plateauBiomes) && Objects.equals(this.plateauBiomesVariant, that.plateauBiomesVariant) && Objects.equals(this.extremeHills, that.extremeHills) && Objects.equals(this.swapper, that.swapper);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.overworldWeight, this.oceans, this.middleBiomes, this.middleBiomesVariant, this.plateauBiomes, this.plateauBiomesVariant, this.extremeHills, this.swapper});
        }

        public String toString() {
            return "BiomeProviderData[overworldWeight=" + this.overworldWeight + ", oceans=" + this.oceans + ", middleBiomes=" + this.middleBiomes + ", middleBiomesVariant=" + this.middleBiomesVariant + ", plateauBiomes=" + this.plateauBiomes + ", plateauBiomesVariant=" + this.plateauBiomesVariant + ", extremeHills=" + this.extremeHills + ", swapper=" + this.swapper + "]";
        }
    }
}

