/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.BYGOverworldBiomes;
import potionstudios.byg.mixin.access.BiomeGenerationSettingsAccess;
import potionstudios.byg.util.RegistryObject;

public class BYGBiomes {
    public static final List<RegistryObject<Biome>> BIOMES = new ArrayList<RegistryObject<Biome>>();
    public static ResourceKey<Biome> ALLIUM_FIELDS = BYGBiomes.createBiome("allium_fields", BYGOverworldBiomes.alliumFields());
    public static ResourceKey<Biome> AMARANTH_FIELDS = BYGBiomes.createBiome("amaranth_fields", BYGOverworldBiomes.amaranthFields());
    public static ResourceKey<Biome> ARAUCARIA_SAVANNA = BYGBiomes.createBiome("araucaria_savanna", BYGOverworldBiomes.araucariaSavanna(false));
    public static ResourceKey<Biome> ASPEN_FOREST = BYGBiomes.createBiome("aspen_forest", BYGOverworldBiomes.aspenForest());
    public static ResourceKey<Biome> AUTUMNAL_VALLEY = BYGBiomes.createBiome("autumnal_valley", BYGOverworldBiomes.autumnalValley());
    public static ResourceKey<Biome> BAOBAB_SAVANNA = BYGBiomes.createBiome("baobab_savanna", BYGOverworldBiomes.baobabSavanna());
    public static ResourceKey<Biome> BAYOU = BYGBiomes.createBiome("bayou", BYGOverworldBiomes.bayou());
    public static ResourceKey<Biome> BLACK_FOREST = BYGBiomes.createBiome("black_forest", BYGOverworldBiomes.blackForest());
    public static ResourceKey<Biome> BOREALIS_GROVE = BYGBiomes.createBiome("borealis_grove", BYGOverworldBiomes.borealisGrove());
    public static ResourceKey<Biome> CANADIAN_SHIELD = BYGBiomes.createBiome("canadian_shield", BYGOverworldBiomes.canadianShield());
    public static ResourceKey<Biome> CHERRY_BLOSSOM_FOREST = BYGBiomes.createBiome("cherry_blossom_forest", BYGOverworldBiomes.cherryBlossomForest());
    public static ResourceKey<Biome> CIKA_WOODS = BYGBiomes.createBiome("cika_woods", BYGOverworldBiomes.cikaWoods());
    public static ResourceKey<Biome> CONIFEROUS_FOREST = BYGBiomes.createBiome("coniferous_forest", BYGOverworldBiomes.coniferousForest(false));
    public static ResourceKey<Biome> CYPRESS_SWAMPLANDS = BYGBiomes.createBiome("cypress_swamplands", BYGOverworldBiomes.cypressSwamplands());
    public static ResourceKey<Biome> DEAD_SEA = BYGBiomes.createBiome("dead_sea", BYGOverworldBiomes.deadSea());
    public static ResourceKey<Biome> DACITE_RIDGES = BYGBiomes.createBiome("dacite_ridges", BYGOverworldBiomes.daciteRidges());
    public static ResourceKey<Biome> EBONY_WOODS = BYGBiomes.createBiome("ebony_woods", BYGOverworldBiomes.ebonyWoods());
    public static ResourceKey<Biome> FORGOTTEN_FOREST = BYGBiomes.createBiome("forgotten_forest", BYGOverworldBiomes.forgottenForest());
    public static ResourceKey<Biome> GROVE = BYGBiomes.createBiome("temperate_grove", BYGOverworldBiomes.temperateGrove(false));
    public static ResourceKey<Biome> GUIANA_SHIELD = BYGBiomes.createBiome("guiana_shield", BYGOverworldBiomes.guianaShield());
    public static ResourceKey<Biome> JACARANDA_FOREST = BYGBiomes.createBiome("jacaranda_forest", BYGOverworldBiomes.jacarandaForest());
    public static ResourceKey<Biome> MAPLE_TAIGA = BYGBiomes.createBiome("maple_taiga", BYGOverworldBiomes.mapleTaiga());
    public static ResourceKey<Biome> CANYON_KEY;

    public static ResourceKey<Biome> createBiome(String id, Biome biome) {
        ResourceLocation bygID = BYG.createLocation(id);
        if (BuiltinRegistries.f_123865_.m_6566_().contains(bygID)) {
            throw new IllegalStateException("Biome ID: \"" + bygID.toString() + "\" already exists in the Biome registry!");
        }
        BIOMES.add(new RegistryObject<Biome>(biome, id));
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)bygID);
    }

    public static void bootStrap(Consumer<Collection<RegistryObject<Biome>>> registryStrategy) {
        registryStrategy.accept(BIOMES);
    }

    public static Collection<RegistryObject<Biome>> bootStrap() {
        return BIOMES;
    }

    public static void addBYGFeaturesToBiomes(Biome biome, ResourceKey<Biome> biomeKey) {
        ResourceLocation locationKey = biomeKey.m_135782_();
        if (biome.m_47567_() != Biome.BiomeCategory.NETHER && biome.m_47567_() != Biome.BiomeCategory.THEEND && biome.m_47567_() != Biome.BiomeCategory.NONE) {
            if (locationKey.equals((Object)Biomes.f_48199_.m_135782_())) {
                // empty if block
            }
            if (biome.m_47567_() != Biome.BiomeCategory.BEACH || biome.m_47554_() > 0.15f) {
                // empty if block
            }
            if (biome.m_47567_() == Biome.BiomeCategory.NETHER || biome.m_47567_() == Biome.BiomeCategory.THEEND || biome.m_47567_() != Biome.BiomeCategory.NONE) {
                // empty if block
            }
        }
    }

    public static void addFeatureToBiomeFirst(Biome biome, ConfiguredFeature<?, ?> configuredFeature) {
        BYGBiomes.convertImmutableFeatures(biome);
        List<List<Supplier<ConfiguredFeature<?, ?>>>> biomeFeatures = ((BiomeGenerationSettingsAccess)biome.m_47536_()).getFeatures();
        List<Supplier<ConfiguredFeature<?, ?>>> suppliers = biomeFeatures.get(GenerationStep.Decoration.RAW_GENERATION.ordinal());
        ArrayList suppliersCopy = new ArrayList(suppliers);
        suppliers.clear();
        suppliers.add(() -> configuredFeature);
        suppliers.addAll(suppliersCopy);
    }

    public static void addFeatureToBiome(Biome biome, GenerationStep.Decoration feature, ConfiguredFeature<?, ?> configuredFeature) {
        BYGBiomes.convertImmutableFeatures(biome);
        List<List<Supplier<ConfiguredFeature<?, ?>>>> biomeFeatures = ((BiomeGenerationSettingsAccess)biome.m_47536_()).getFeatures();
        while (biomeFeatures.size() <= feature.ordinal()) {
            biomeFeatures.add(Lists.newArrayList());
        }
        biomeFeatures.get(feature.ordinal()).add(() -> configuredFeature);
    }

    private static void convertImmutableFeatures(Biome biome) {
        List<List<Supplier<ConfiguredFeature<?, ?>>>> features = ((BiomeGenerationSettingsAccess)biome.m_47536_()).getFeatures();
        if (features instanceof ImmutableList) {
            ((BiomeGenerationSettingsAccess)biome.m_47536_()).setFeatures(features.stream().map(Lists::newArrayList).collect(Collectors.toList()));
        }
    }
}

