/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.entity.boat;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.entity.BYGEntities;
import potionstudios.byg.common.item.BYGItems;
import potionstudios.byg.mixin.access.BoatEntityAccess;

public class BYGBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> BYG_BOAT_TYPE = SynchedEntityData.m_135353_(BYGBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BYGBoatEntity(Level worldIn, double x, double y, double z) {
        this(BYGEntities.BOAT, worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public BYGBoatEntity(EntityType<? extends Boat> boatEntityType, Level worldType) {
        super(boatEntityType, worldType);
    }

    public Item m_38369_() {
        switch (this.getBYGBoatType()) {
            default: {
                return BYGItems.ASPEN_BOAT;
            }
            case BAOBAB: {
                return BYGItems.BAOBAB_BOAT;
            }
            case BLUE_ENCHANTED: {
                return BYGItems.BLUE_ENCHANTED_BOAT;
            }
            case CHERRY: {
                return BYGItems.CHERRY_BOAT;
            }
            case CIKA: {
                return BYGItems.CIKA_BOAT;
            }
            case CYPRESS: {
                return BYGItems.CYPRESS_BOAT;
            }
            case EBONY: {
                return BYGItems.EBONY_BOAT;
            }
            case FIR: {
                return BYGItems.FIR_BOAT;
            }
            case GREEN_ENCHANTED: {
                return BYGItems.GREEN_ENCHANTED_BOAT;
            }
            case HOLLY: {
                return BYGItems.HOLLY_BOAT;
            }
            case JACARANDA: {
                return BYGItems.JACARANDA_BOAT;
            }
            case MAHOGANY: {
                return BYGItems.MAHOGANY_BOAT;
            }
            case MANGROVE: {
                return BYGItems.MANGROVE_BOAT;
            }
            case MAPLE: {
                return BYGItems.MAPLE_BOAT;
            }
            case PINE: {
                return BYGItems.PINE_BOAT;
            }
            case RAINBOW_EUCALYPTUS: {
                return BYGItems.RAINBOW_EUCALYPTUS_BOAT;
            }
            case REDWOOD: {
                return BYGItems.REDWOOD_BOAT;
            }
            case SKYRIS: {
                return BYGItems.SKYRIS_BOAT;
            }
            case WILLOW: {
                return BYGItems.WILLOW_BOAT;
            }
            case WITCH_HAZEL: {
                return BYGItems.WITCH_HAZEL_BOAT;
            }
            case ZELKOVA: {
                return BYGItems.ZELKOVA_BOAT;
            }
            case PALM: 
        }
        return BYGItems.PALM_BOAT;
    }

    public Block getPlanks() {
        switch (this.getBYGBoatType()) {
            default: {
                return BYGBlocks.ASPEN_PLANKS;
            }
            case BAOBAB: {
                return BYGBlocks.BAOBAB_PLANKS;
            }
            case BLUE_ENCHANTED: {
                return BYGBlocks.BLUE_ENCHANTED_PLANKS;
            }
            case CHERRY: {
                return BYGBlocks.CHERRY_PLANKS;
            }
            case CIKA: {
                return BYGBlocks.CIKA_PLANKS;
            }
            case CYPRESS: {
                return BYGBlocks.CYPRESS_PLANKS;
            }
            case EBONY: {
                return BYGBlocks.EBONY_PLANKS;
            }
            case FIR: {
                return BYGBlocks.FIR_PLANKS;
            }
            case GREEN_ENCHANTED: {
                return BYGBlocks.GREEN_ENCHANTED_PLANKS;
            }
            case HOLLY: {
                return BYGBlocks.HOLLY_PLANKS;
            }
            case JACARANDA: {
                return BYGBlocks.JACARANDA_PLANKS;
            }
            case MAHOGANY: {
                return BYGBlocks.MAHOGANY_PLANKS;
            }
            case MANGROVE: {
                return BYGBlocks.MANGROVE_PLANKS;
            }
            case MAPLE: {
                return BYGBlocks.MAPLE_PLANKS;
            }
            case PALM: {
                return BYGBlocks.PALM_PLANKS;
            }
            case PINE: {
                return BYGBlocks.PINE_PLANKS;
            }
            case RAINBOW_EUCALYPTUS: {
                return BYGBlocks.RAINBOW_EUCALYPTUS_PLANKS;
            }
            case REDWOOD: {
                return BYGBlocks.REDWOOD_PLANKS;
            }
            case SKYRIS: {
                return BYGBlocks.SKYRIS_PLANKS;
            }
            case WILLOW: {
                return BYGBlocks.WILLOW_PLANKS;
            }
            case WITCH_HAZEL: {
                return BYGBlocks.WITCH_HAZEL_PLANKS;
            }
            case ZELKOVA: 
        }
        return BYGBlocks.ZELKOVA_PLANKS;
    }

    public BYGType getBYGBoatType() {
        return BYGType.byId((Integer)this.f_19804_.m_135370_(BYG_BOAT_TYPE));
    }

    public void setBYGBoatType(BYGType boatBYGType) {
        this.f_19804_.m_135381_(BYG_BOAT_TYPE, (Object)boatBYGType.ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BYG_BOAT_TYPE, (Object)BYGType.ASPEN.ordinal());
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("BYGType", this.getBYGBoatType().getName());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("BYGType", 8)) {
            this.setBYGBoatType(BYGType.getTypeFromString(compound.m_128461_("BYGType")));
        }
    }

    public void m_6053_() {
        this.m_38362_(-this.m_38386_());
        this.m_38354_(10);
        this.m_38311_(this.m_38384_() * 11.0f);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        ((BoatEntityAccess)((Object)this)).setLastYd(this.m_20184_().f_82480_);
        if (!this.m_20159_()) {
            if (onGroundIn) {
                if (this.f_19789_ > 3.0f) {
                    if (((BoatEntityAccess)((Object)this)).getStatusField() != Boat.Status.ON_LAND) {
                        this.f_19789_ = 0.0f;
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                            this.m_19998_((ItemLike)Blocks.f_50016_);
                        }
                    }
                }
                this.f_19789_ = 0.0f;
            } else if (!this.f_19853_.m_6425_(new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_7495_()).m_76153_((Tag)FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - y);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            boolean flag;
            if (source instanceof IndirectEntityDamageSource && source.m_7639_() != null && this.m_20363_(source.m_7639_())) {
                return false;
            }
            this.m_38362_(-this.m_38386_());
            this.m_38354_(10);
            this.m_38311_(this.m_38384_() + amount * 10.0f);
            this.m_5834_();
            boolean bl = flag = source.m_7639_() instanceof Player && ((Player)source.m_7639_()).m_150110_().f_35937_;
            if (flag || this.m_38384_() > 40.0f) {
                if (!flag && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.m_19998_((ItemLike)this.m_38369_());
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public static enum BYGType {
        ASPEN("aspen"),
        BAOBAB("baobab"),
        BLUE_ENCHANTED("blue_enchanted"),
        CHERRY("cherry"),
        CIKA("cika"),
        CYPRESS("cypress"),
        EBONY("ebony"),
        FIR("fir"),
        GREEN_ENCHANTED("green_enchanted"),
        HOLLY("holly"),
        JACARANDA("jacaranda"),
        MAHOGANY("mahogony"),
        MANGROVE("mangrove"),
        MAPLE("maple"),
        PALM("palm"),
        PINE("pine"),
        RAINBOW_EUCALYPTUS("rainbow_eucalyptus"),
        REDWOOD("redwood"),
        SKYRIS("skyris"),
        WILLOW("willow"),
        WITCH_HAZEL("witch_hazel"),
        ZELKOVA("zelkova");

        private final String name;

        private BYGType(String string2) {
            this.name = string2;
        }

        public static BYGType byId(int id) {
            BYGType[] aBYGBoatEntity$BYGType = BYGType.values();
            if (id < 0 || id >= aBYGBoatEntity$BYGType.length) {
                id = 0;
            }
            return aBYGBoatEntity$BYGType[id];
        }

        public static BYGType getTypeFromString(String nameIn) {
            BYGType[] aBYGBoatEntity$BYGType;
            for (BYGType BYGType2 : aBYGBoatEntity$BYGType = BYGType.values()) {
                if (!BYGType2.getName().equals(nameIn)) continue;
                return BYGType2;
            }
            return aBYGBoatEntity$BYGType[0];
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

