/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.block.sapling;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.Tag;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import potionstudios.byg.BYG;
import potionstudios.byg.common.block.sapling.SaplingPatterns;
import potionstudios.byg.util.BYGUtil;
import potionstudios.byg.util.CommonSetupLoad;

public class BYGSapling
extends SaplingBlock
implements CommonSetupLoad {
    public static final List<CommonSetupLoad> SERIALIZERS = new ArrayList<CommonSetupLoad>();
    private final List<Pair<List<BlockPos>, SimpleWeightedRandomList<SaplingPatterns.FeatureSpawner>>> patternsToSpawner = new ArrayList<Pair<List<BlockPos>, SimpleWeightedRandomList<SaplingPatterns.FeatureSpawner>>>();
    private final String id;
    private final Tag<Block> groundTag;

    public BYGSapling(String id, BlockBehaviour.Properties properties, Tag<Block> groundTag) {
        super(null, properties);
        this.id = id;
        this.groundTag = groundTag;
        SERIALIZERS.add(this);
    }

    private void serializePatterns(ResourceLocation key) {
        this.patternsToSpawner.clear();
        Map<ResourceLocation, List<SaplingPatterns.PatternEntry>> patterns = SaplingPatterns.getConfig().saplingPatterns();
        if (patterns.containsKey(key)) {
            ArrayList<SaplingPatterns.PatternEntry> patternsToSpawner = new ArrayList<SaplingPatterns.PatternEntry>((Collection)patterns.get(key));
            patternsToSpawner.sort(Comparator.comparingInt(p -> {
                int saplingCount = 0;
                for (String s : p.pattern()) {
                    char[] chars;
                    for (char aChar : chars = s.toCharArray()) {
                        if (aChar != 'x' && aChar != 'X') continue;
                        ++saplingCount;
                    }
                }
                return saplingCount;
            }));
            ArrayList<Pair> patternsToSpawnerMapped = new ArrayList<Pair>();
            for (SaplingPatterns.PatternEntry patternEntry : patternsToSpawner) {
                List<String> pattern = patternEntry.pattern();
                SimpleWeightedRandomList<SaplingPatterns.FeatureSpawner> spawner = patternEntry.spawners();
                Pair newEntry = Pair.of(new ArrayList(), spawner);
                patternsToSpawnerMapped.add(newEntry);
                int patternLoopSize = Math.min(pattern.size(), 5);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < patternLoopSize; ++i) {
                    String s = pattern.get(i);
                    String substring = s.substring(0, Math.min(s.length(), 5));
                    builder.append(substring);
                }
                String patternCombined = builder.toString();
                String trimmed = patternCombined.trim();
                if (trimmed.length() > 1) {
                    int zOffset = -patternLoopSize / 2;
                    for (int i = 0; i < patternLoopSize; ++i) {
                        char[] charArray;
                        String s = pattern.get(i);
                        int range = Math.min(s.length(), 5);
                        String substring = s.substring(0, range);
                        int xOffset = -range / 2;
                        for (char c : charArray = substring.toCharArray()) {
                            if (c == 'x' || c == 'X') {
                                ((List)newEntry.getFirst()).add(new BlockPos(xOffset, 0, zOffset));
                            }
                            ++xOffset;
                        }
                        ++zOffset;
                    }
                    continue;
                }
                ((List)newEntry.getFirst()).add(new BlockPos(0, 0, 0));
            }
            this.patternsToSpawner.addAll(patternsToSpawnerMapped);
            Collections.reverse(this.patternsToSpawner);
        }
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_60620_(this.groundTag);
    }

    public void m_55980_(ServerLevel world, BlockPos pos, BlockState state, Random rand) {
        if ((Integer)state.m_61143_((Property)f_55973_) == 0) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)f_55973_), 4);
        } else {
            int range = 2;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
            for (Pair<List<BlockPos>, SimpleWeightedRandomList<SaplingPatterns.FeatureSpawner>> entry : this.patternsToSpawner) {
                for (int xMove = -range; xMove <= range; ++xMove) {
                    for (int zMove = -range; zMove <= range; ++zMove) {
                        boolean matchedPattern = true;
                        BlockPos.MutableBlockPos mutableBlockPos1 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutableBlockPos.m_122190_((Vec3i)pos).m_122184_(xMove, 0, zMove));
                        List offsets = (List)entry.getFirst();
                        SimpleWeightedRandomList treePicker = (SimpleWeightedRandomList)entry.getSecond();
                        for (BlockPos offset : offsets) {
                            BlockPos.MutableBlockPos movedPos = mutableBlockPos1.m_122190_((Vec3i)mutableBlockPos).m_122193_((Vec3i)offset);
                            BlockState offsetState = world.m_8055_((BlockPos)movedPos);
                            if (offsetState.m_60734_() == this) continue;
                            matchedPattern = false;
                            break;
                        }
                        if (!matchedPattern) continue;
                        Optional configuredFeaturesOptionalRegistry = world.m_5962_().m_142664_(Registry.f_122881_);
                        if (configuredFeaturesOptionalRegistry.isPresent()) {
                            WritableRegistry configuredFeaturesRegistry = (WritableRegistry)configuredFeaturesOptionalRegistry.get();
                            Optional randomValue = treePicker.m_146266_(rand);
                            if (randomValue.isPresent()) {
                                SaplingPatterns.FeatureSpawner featureSpawner = (SaplingPatterns.FeatureSpawner)randomValue.get();
                                ConfiguredFeature configuredFeature = (ConfiguredFeature)configuredFeaturesRegistry.m_7745_(featureSpawner.spawnerID());
                                if (configuredFeature != null) {
                                    BlockPos spawnOffset = featureSpawner.spawnOffset();
                                    BlockPos growthPos = mutableBlockPos1.m_141952_((Vec3i)spawnOffset);
                                    if (configuredFeature.m_65385_((WorldGenLevel)world, world.m_7726_().m_8481_(), rand, growthPos)) {
                                        for (BlockPos offset : offsets) {
                                            BlockPos.MutableBlockPos movedPos = mutableBlockPos1.m_122190_((Vec3i)mutableBlockPos).m_122193_((Vec3i)offset);
                                            BlockState offsetState = world.m_8055_((BlockPos)movedPos);
                                            if (offsetState.m_60734_() != this) continue;
                                            world.m_7471_((BlockPos)movedPos, false);
                                        }
                                        if (SaplingPatterns.getConfig().logSaplingGrowth()) {
                                            BYG.LOGGER.info(String.format("Sapling \"%s\" grew configured feature \"%s\" at position %s(growth offset: %s).", Registry.f_122824_.m_7981_((Object)this).toString(), featureSpawner.toString(), growthPos, spawnOffset));
                                        }
                                    }
                                } else {
                                    BYG.LOGGER.error(String.format("Sapling: \"%s\" failed when attempting to spawn configured feature \"%s\" at position %s. \"%s\" is not a valid configured feature ID in this world's datapack configured feature registry! Valid entries:\n %s", Registry.f_122824_.m_7981_((Object)this).toString(), featureSpawner, pos, featureSpawner, BYGUtil.dumpRegistry(configuredFeaturesRegistry)));
                                }
                            }
                        }
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void load() {
        this.serializePatterns(BYG.createLocation(this.id));
    }
}

