/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import potionstudios.byg.common.world.feature.overworld.mushrooms.util.BYGHugeMushroom;
import potionstudios.byg.util.MLBlockTags;

public class BYGMushroomPlantBlock
extends BushBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    private final BYGHugeMushroom mushroom;
    private final boolean isNetherFungi;

    public BYGMushroomPlantBlock(BlockBehaviour.Properties properties, BYGHugeMushroom mushroom, boolean isNetherFungi) {
        super(properties);
        this.mushroom = mushroom;
        this.isNetherFungi = isNetherFungi;
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.isNetherFungi ? state.m_60620_((Tag)BlockTags.f_13077_) || state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50136_) || state.m_60620_((Tag)BlockTags.f_13062_) || state.m_60620_(MLBlockTags.NETHERRACK) || super.m_6266_(state, worldIn, pos) : state.m_60804_(worldIn, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (this.isNetherFungi) {
            return super.m_7898_(state, worldIn, pos);
        }
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (blockstate.m_60620_((Tag)BlockTags.f_13057_)) {
            return true;
        }
        return worldIn.m_45524_(pos, 0) < 13 && this.m_6266_(blockstate, (BlockGetter)worldIn, blockpos);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(25) == 0) {
            int i = 5;
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-4, -1, -4), (BlockPos)pos.m_142082_(4, 1, 4))) {
                if (worldIn.m_8055_(blockpos).m_60734_() != this || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.m_142082_(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (worldIn.m_46859_(blockpos1) && state.m_60710_((LevelReader)worldIn, blockpos1)) {
                    pos = blockpos1;
                }
                blockpos1 = pos.m_142082_(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            if (worldIn.m_46859_(blockpos1) && state.m_60710_((LevelReader)worldIn, blockpos1)) {
                worldIn.m_7731_(blockpos1, state, 2);
            }
        }
    }

    public void grow(ServerLevel worldIn, BlockPos pos, BlockState state, Random rand) {
        worldIn.m_7471_(pos, false);
        this.mushroom.withSpawner((WorldGenLevel)worldIn, worldIn.m_7726_().m_8481_(), pos, state, rand);
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)worldIn.f_46441_.nextFloat() < 0.25;
    }

    public void m_7719_(ServerLevel world, Random rand, BlockPos pos, BlockState state) {
        this.grow(world, pos, state, rand);
    }
}

