/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import com.blakebr0.cucumber.helper.NBTHelper;
import java.util.Set;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public final class StackHelper {
    public static ItemStack withSize(ItemStack stack, int size, boolean container) {
        if (size <= 0) {
            if (container && stack.hasContainerItem()) {
                return stack.getContainerItem();
            }
            return ItemStack.f_41583_;
        }
        stack = stack.m_41777_();
        stack.m_41764_(size);
        return stack;
    }

    public static ItemStack grow(ItemStack stack, int amount) {
        return StackHelper.withSize(stack, stack.m_41613_() + amount, false);
    }

    public static ItemStack shrink(ItemStack stack, int amount, boolean container) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return StackHelper.withSize(stack, stack.m_41613_() - amount, container);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41619_() && stack2.m_41619_()) {
            return true;
        }
        return !stack1.m_41619_() && stack1.m_41656_(stack2);
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return StackHelper.areItemsEqual(stack1, stack2) && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean canCombineStacks(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_41619_() && stack2.m_41619_()) {
            return true;
        }
        return StackHelper.areStacksEqual(stack1, stack2) && stack1.m_41613_() + stack2.m_41613_() <= stack1.m_41741_();
    }

    public static ItemStack combineStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41619_()) {
            return stack2.m_41777_();
        }
        return StackHelper.grow(stack1, stack2.m_41613_());
    }

    public static boolean compareTags(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_41782_()) {
            return true;
        }
        if (stack1.m_41782_() && !stack2.m_41782_()) {
            return false;
        }
        Set stack1Keys = NBTHelper.getTagCompound(stack1).m_128431_();
        Set stack2Keys = NBTHelper.getTagCompound(stack2).m_128431_();
        for (String key : stack1Keys) {
            if (stack2Keys.contains(key)) {
                if (NbtUtils.m_129235_((Tag)NBTHelper.getTag(stack1, key), (Tag)NBTHelper.getTag(stack2, key), (boolean)true)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

