/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import com.supermartijn642.chunkloaders.screen.ChunkButton;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.TileEntityBaseScreen;
import com.supermartijn642.core.gui.widget.Widget;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;

public class ChunkLoaderScreen
extends TileEntityBaseScreen<ChunkLoaderTile> {
    private final int backgroundSize;
    private final List<ChunkButton> buttons = new LinkedList<ChunkButton>();
    private boolean doDrag = false;
    private boolean dragState = false;
    private List<ChunkButton> draggedButtons = new ArrayList<ChunkButton>();

    public ChunkLoaderScreen(String type, BlockPos pos) {
        super((Component)TextComponents.translation((String)("block.chunkloaders." + type)).get(), pos);
        ChunkLoaderTile tile = (ChunkLoaderTile)((Object)this.getObjectOrClose());
        int gridSize = tile == null ? 1 : tile.getGridSize();
        this.backgroundSize = gridSize * 15 + (gridSize - 1) + 16;
    }

    protected float sizeX(@Nonnull ChunkLoaderTile blockEntity) {
        return this.backgroundSize;
    }

    protected float sizeY(@Nonnull ChunkLoaderTile blockEntity) {
        return this.backgroundSize;
    }

    protected void addWidgets(@Nonnull ChunkLoaderTile blockEntity) {
        this.buttons.clear();
        int radius = (blockEntity.getGridSize() - 1) / 2;
        for (int x = 0; x < blockEntity.getGridSize(); ++x) {
            for (int y = 0; y < blockEntity.getGridSize(); ++y) {
                this.buttons.add((ChunkButton)this.addWidget((Widget)new ChunkButton(8 + x * 16, 8 + y * 16, -radius + x, -radius + y, () -> (ChunkLoaderTile)((Object)((Object)this.getObjectOrClose())), new ChunkPos((this.tilePos.m_123341_() >> 4) - radius + x, (this.tilePos.m_123343_() >> 4) - radius + y))));
            }
        }
    }

    protected void render(PoseStack matrixStack, int mouseX, int mouseY, @Nonnull ChunkLoaderTile blockEntity) {
        this.drawScreenBackground(matrixStack);
    }

    protected void onMousePress(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (ChunkButton button : this.buttons) {
                if (!button.isHovered()) continue;
                this.doDrag = true;
                this.dragState = !button.isLoaded();
                this.draggedButtons.clear();
                this.draggedButtons.add(button);
                return;
            }
        }
    }

    protected void onMouseRelease(int mouseX, int mouseY, int button) {
        if (button == 0) {
            this.doDrag = false;
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.doDrag && mouseButton == 0) {
            for (ChunkButton button : this.buttons) {
                if (this.draggedButtons.contains((Object)button) || !button.isHovered() || button.isLoaded() == this.dragState) continue;
                button.onPress();
                this.draggedButtons.add(button);
                return true;
            }
        }
        return false;
    }
}

