/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.packet;

import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public abstract class ChunkLoaderPacket {
    protected BlockPos pos;

    public ChunkLoaderPacket(BlockPos pos) {
        this.pos = pos;
    }

    public ChunkLoaderPacket(FriendlyByteBuf buffer) {
        this.decodeBuffer(buffer);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
    }

    protected void decodeBuffer(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().setPacketHandled(true);
        ServerPlayer player = contextSupplier.get().getSender();
        if (player == null || player.m_142538_().m_123331_((Vec3i)this.pos) > 1024.0) {
            return;
        }
        Level world = player.f_19853_;
        if (world == null) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof ChunkLoaderTile) {
            contextSupplier.get().enqueueWork(() -> this.lambda$handle$0((Player)player, world, tile));
        }
    }

    protected abstract void handle(Player var1, Level var2, ChunkLoaderTile var3);

    private /* synthetic */ void lambda$handle$0(Player player, Level world, BlockEntity tile) {
        this.handle(player, world, (ChunkLoaderTile)tile);
    }
}

