/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiouselytra.client;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.caelus.api.RenderCapeEvent;
import top.theillusivec4.curiouselytra.CuriousElytraMod;
import top.theillusivec4.curiouselytra.client.CurioElytraLayer;

public class CuriousElytraClientMod {
    public static void setup() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(CuriousElytraClientMod::addLayers);
        MinecraftForge.EVENT_BUS.addListener(CuriousElytraClientMod::renderCape);
    }

    private static void addLayers(EntityRenderersEvent.AddLayers evt) {
        CuriousElytraClientMod.addPlayerLayer(evt, "default");
        CuriousElytraClientMod.addPlayerLayer(evt, "slim");
        CuriousElytraClientMod.addEntityLayer(evt, EntityType.f_20529_);
    }

    private static void addPlayerLayer(EntityRenderersEvent.AddLayers evt, String skin) {
        LivingEntityRenderer renderer = evt.getSkin(skin);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = renderer;
            livingRenderer.m_115326_(new CurioElytraLayer(livingRenderer, evt.getEntityModels()));
        }
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>, R extends LivingEntityRenderer<T, M>> void addEntityLayer(EntityRenderersEvent.AddLayers evt, EntityType<? extends T> entityType) {
        LivingEntityRenderer renderer = evt.getRenderer(entityType);
        if (renderer != null) {
            renderer.m_115326_(new CurioElytraLayer(renderer, evt.getEntityModels()));
        }
    }

    private static void renderCape(RenderCapeEvent evt) {
        if (CuriousElytraMod.getElytra((LivingEntity)evt.getPlayer(), false).isPresent()) {
            evt.setCanceled(true);
        }
    }
}

