/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyFilterSlot;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SetFilterSlotMessage {
    private final int containerSlot;
    private final ItemStack stack;

    public SetFilterSlotMessage(int containerSlot, ItemStack stack) {
        this.containerSlot = containerSlot;
        this.stack = stack;
    }

    public static SetFilterSlotMessage decode(FriendlyByteBuf buf) {
        return new SetFilterSlotMessage(buf.readInt(), buf.m_130267_());
    }

    public static void encode(SetFilterSlotMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.containerSlot);
        buf.m_130055_(message.stack);
    }

    public static void handle(SetFilterSlotMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player;
        if (!message.stack.m_41619_() && message.stack.m_41613_() <= message.stack.m_41741_() && (player = ctx.get().getSender()) != null) {
            ctx.get().enqueueWork(() -> SetFilterSlotMessage.lambda$handle$0((Player)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static void handle(SetFilterSlotMessage message, AbstractContainerMenu container) {
        Slot slot = container.m_38853_(message.containerSlot);
        if (slot instanceof FilterSlot || slot instanceof LegacyFilterSlot) {
            IGrid grid;
            Runnable postAction = () -> {};
            if (container instanceof GridContainerMenu && (grid = ((GridContainerMenu)container).getGrid()) instanceof GridNetworkNode && slot.getSlotIndex() < ((GridNetworkNode)grid).getAllowedTagList().getAllowedItemTags().size()) {
                HashSet list = new HashSet(((GridNetworkNode)grid).getAllowedTagList().getAllowedItemTags().get(slot.getSlotIndex()));
                postAction = () -> {
                    ((GridNetworkNode)grid).getAllowedTagList().setAllowedItemTags(slot.getSlotIndex(), list);
                    ((GridNetworkNode)grid).markDirty();
                };
            }
            slot.m_5852_(message.stack);
            postAction.run();
        }
    }

    private static /* synthetic */ void lambda$handle$0(Player player, SetFilterSlotMessage message) {
        AbstractContainerMenu container = player.f_36096_;
        if (container != null && message.containerSlot >= 0 && message.containerSlot < container.f_38839_.size()) {
            SetFilterSlotMessage.handle(message, container);
        }
    }
}

