/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.disk.factory;

import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskFactory;
import com.refinedmods.refinedstorage.apiimpl.storage.FluidStorageType;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.FluidStorageDisk;
import com.refinedmods.refinedstorage.item.FluidStorageDiskItem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class FluidStorageDiskFactory
implements IStorageDiskFactory<FluidStack> {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "fluid");

    @Override
    public IStorageDisk<FluidStack> createFromNbt(ServerLevel level, CompoundTag tag) {
        FluidStorageDisk disk = new FluidStorageDisk(level, tag.m_128451_("Capacity"), tag.m_128441_("Owner") ? tag.m_128342_("Owner") : null);
        ListTag list = tag.m_128437_("Fluids", 10);
        for (int i = 0; i < list.size(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)list.m_128728_(i));
            if (stack.isEmpty()) continue;
            disk.getRawStacks().put((Object)stack.getRawFluid(), (Object)stack);
        }
        return disk;
    }

    @Override
    public ItemStack createDiskItem(IStorageDisk<FluidStack> disk, UUID id) {
        FluidStorageDiskItem item = switch (disk.getCapacity()) {
            case 64000 -> (FluidStorageDiskItem)RSItems.FLUID_STORAGE_DISKS.get((Object)FluidStorageType.SIXTY_FOUR_K).get();
            case 256000 -> (FluidStorageDiskItem)RSItems.FLUID_STORAGE_DISKS.get((Object)FluidStorageType.TWO_HUNDRED_FIFTY_SIX_K).get();
            case 1024000 -> (FluidStorageDiskItem)RSItems.FLUID_STORAGE_DISKS.get((Object)FluidStorageType.THOUSAND_TWENTY_FOUR_K).get();
            case 4096000 -> (FluidStorageDiskItem)RSItems.FLUID_STORAGE_DISKS.get((Object)FluidStorageType.FOUR_THOUSAND_NINETY_SIX_K).get();
            default -> (FluidStorageDiskItem)RSItems.FLUID_STORAGE_DISKS.get((Object)FluidStorageType.CREATIVE).get();
        };
        ItemStack stack = new ItemStack((ItemLike)item);
        item.setId(stack, id);
        return stack;
    }

    @Override
    public IStorageDisk<FluidStack> create(ServerLevel level, int capacity, @Nullable UUID owner) {
        return new FluidStorageDisk(level, capacity, owner);
    }
}

