/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid.handler;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.grid.handler.ItemGridHandler;
import com.refinedmods.refinedstorage.blockentity.grid.portable.IPortableGrid;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PortableItemGridHandler
implements IItemGridHandler {
    private final IPortableGrid portableGrid;
    private final IGrid grid;

    public PortableItemGridHandler(IPortableGrid portableGrid, IGrid grid) {
        this.portableGrid = portableGrid;
        this.grid = grid;
    }

    @Override
    public void onExtract(ServerPlayer player, ItemStack stack, int preferredSlot, int flags) {
        if (this.portableGrid.getStorage() == null || !this.grid.isGridActive()) {
            return;
        }
        if (this.portableGrid.getItemCache().getList().getEntry(stack, 1) != null) {
            this.onExtract(player, this.portableGrid.getItemCache().getList().getEntry(stack, 1).getId(), preferredSlot, flags);
        }
    }

    @Override
    public void onExtract(ServerPlayer player, UUID id, int preferredSlot, int flags) {
        if (this.portableGrid.getStorage() == null || !this.grid.isGridActive()) {
            return;
        }
        ItemStack item = this.portableGrid.getItemCache().getList().get(id);
        if (item == null) {
            return;
        }
        int itemSize = item.m_41613_();
        int maxItemSize = item.m_41720_().getItemStackLimit(item.m_41777_());
        boolean single = (flags & 2) == 2;
        ItemStack held = player.f_36096_.m_142621_();
        if (single ? !held.m_41619_() && (!API.instance().getComparer().isEqualNoQuantity(item, held) || held.m_41613_() + 1 > held.m_41741_()) : !player.f_36096_.m_142621_().m_41619_()) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > maxItemSize / 2 && maxItemSize != 1) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        size = Math.min(size, maxItemSize);
        this.portableGrid.getItemStorageTracker().changed((Player)player, item.m_41777_());
        ItemStack took = this.portableGrid.getItemStorage().extract(item, size, 1, Action.SIMULATE);
        if (!took.m_41619_()) {
            if ((flags & 4) == 4) {
                IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElse(null);
                if (playerInventory != null) {
                    ItemStack remainder;
                    if (preferredSlot != -1 && (remainder = playerInventory.insertItem(preferredSlot, took, true)).m_41613_() != took.m_41613_()) {
                        ItemStack inserted = this.portableGrid.getItemStorage().extract(item, size - remainder.m_41613_(), 1, Action.PERFORM);
                        playerInventory.insertItem(preferredSlot, inserted, false);
                        took.m_41764_(remainder.m_41613_());
                    }
                    if (!took.m_41619_() && ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)took, (boolean)true).m_41619_()) {
                        took = this.portableGrid.getItemStorage().extract(item, size, 1, Action.PERFORM);
                        ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)took, (boolean)false);
                    }
                }
            } else {
                took = this.portableGrid.getItemStorage().extract(item, size, 1, Action.PERFORM);
                if (single && !held.m_41619_()) {
                    held.m_41769_(1);
                } else {
                    player.f_36096_.m_142503_(took);
                }
            }
            this.portableGrid.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getExtractUsage());
        }
    }

    @Override
    @Nonnull
    public ItemStack onInsert(ServerPlayer player, ItemStack stack, boolean single) {
        ItemStack remainder;
        if (this.portableGrid.getStorage() == null || !this.grid.isGridActive()) {
            return stack;
        }
        this.portableGrid.getItemStorageTracker().changed((Player)player, stack.m_41777_());
        if (single) {
            if (this.portableGrid.getItemStorage().insert(stack, 1, Action.SIMULATE).m_41619_()) {
                this.portableGrid.getItemStorage().insert(stack, 1, Action.PERFORM);
                stack.m_41774_(1);
            }
            remainder = stack;
        } else {
            remainder = this.portableGrid.getItemStorage().insert(stack, stack.m_41613_(), Action.PERFORM);
        }
        this.portableGrid.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getInsertUsage());
        return remainder;
    }

    @Override
    public void onInsertHeldItem(ServerPlayer player, boolean single) {
        if (player.f_36096_.m_142621_().m_41619_() || this.portableGrid.getStorage() == null || !this.grid.isGridActive()) {
            return;
        }
        ItemStack stack = player.f_36096_.m_142621_();
        int size = single ? 1 : stack.m_41613_();
        this.portableGrid.getItemStorageTracker().changed((Player)player, stack.m_41777_());
        if (single) {
            if (this.portableGrid.getItemStorage().insert(stack, size, Action.SIMULATE).m_41619_()) {
                this.portableGrid.getItemStorage().insert(stack, size, Action.PERFORM);
                stack.m_41774_(size);
            }
        } else {
            player.f_36096_.m_142503_(this.portableGrid.getItemStorage().insert(stack, size, Action.PERFORM));
        }
        this.portableGrid.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getInsertUsage());
    }

    @Override
    public void onCraftingPreviewRequested(ServerPlayer player, UUID id, int quantity, boolean noPreview) {
    }

    @Override
    public void onCraftingRequested(ServerPlayer player, UUID id, int quantity) {
    }

    @Override
    public void onCraftingCancelRequested(ServerPlayer player, @Nullable UUID id) {
    }

    @Override
    public void onInventoryScroll(ServerPlayer player, int slot, boolean shift, boolean up) {
        ItemGridHandler.onInventoryScroll(this, player, slot, shift, up, null);
    }

    @Override
    public void onGridScroll(ServerPlayer player, @Nullable UUID id, boolean shift, boolean up) {
        ItemGridHandler.onGridScroll(this, player, id, shift, up, null);
    }
}

