/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid.handler;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.blockentity.grid.portable.IPortableGrid;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class PortableFluidGridHandler
implements IFluidGridHandler {
    private final IPortableGrid portableGrid;

    public PortableFluidGridHandler(IPortableGrid portableGrid) {
        this.portableGrid = portableGrid;
    }

    @Override
    public void onExtract(ServerPlayer player, UUID id, boolean shift) {
        if (!this.portableGrid.isGridActive()) {
            return;
        }
        FluidStack stack = this.portableGrid.getFluidCache().getList().get(id);
        if (stack == null || stack.getAmount() < 1000) {
            return;
        }
        ItemStack bucket = ItemStack.f_41583_;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack slot = player.m_150109_().m_8020_(i);
            if (!API.instance().getComparer().isEqualNoQuantity(StackUtils.EMPTY_BUCKET, slot)) continue;
            bucket = StackUtils.EMPTY_BUCKET.m_41777_();
            player.m_150109_().m_7407_(i, 1);
            break;
        }
        if (!bucket.m_41619_()) {
            bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(fluidHandler -> {
                this.portableGrid.getFluidStorageTracker().changed((Player)player, stack.copy());
                fluidHandler.fill(this.portableGrid.getFluidStorage().extract(stack, 1000, 1, Action.PERFORM), IFluidHandler.FluidAction.EXECUTE);
                if (shift) {
                    if (!player.m_150109_().m_36054_(fluidHandler.getContainer().m_41777_())) {
                        Containers.m_18992_((Level)player.m_20193_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)fluidHandler.getContainer());
                    }
                } else {
                    player.f_36096_.m_142503_(fluidHandler.getContainer());
                }
                this.portableGrid.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getExtractUsage());
            });
        }
    }

    @Override
    @Nonnull
    public ItemStack onInsert(ServerPlayer player, ItemStack container) {
        if (!this.portableGrid.isGridActive()) {
            return container;
        }
        Pair<ItemStack, FluidStack> result = StackUtils.getFluid(container, true);
        if (!((FluidStack)result.getValue()).isEmpty() && this.portableGrid.getFluidStorage().insert((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.SIMULATE).isEmpty()) {
            this.portableGrid.getFluidStorageTracker().changed((Player)player, ((FluidStack)result.getValue()).copy());
            result = StackUtils.getFluid(container, false);
            this.portableGrid.getFluidStorage().insert((FluidStack)result.getValue(), ((FluidStack)result.getValue()).getAmount(), Action.PERFORM);
            this.portableGrid.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getInsertUsage());
            return (ItemStack)result.getLeft();
        }
        return container;
    }

    @Override
    public void onInsertHeldContainer(ServerPlayer player) {
        player.f_36096_.m_142503_(this.onInsert(player, player.f_36096_.m_142621_()));
    }

    @Override
    public void onCraftingPreviewRequested(ServerPlayer player, UUID id, int quantity, boolean noPreview) {
    }

    @Override
    public void onCraftingRequested(ServerPlayer player, UUID id, int quantity) {
    }
}

