/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.preview;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.refinedmods.refinedstorage.api.render.IElementDrawers;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class FluidCraftingPreviewElement
implements ICraftingPreviewElement {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "fluid");
    private final FluidStack stack;
    private int available;
    private boolean missing;
    private int toCraft;

    public FluidCraftingPreviewElement(FluidStack stack) {
        this.stack = stack.copy();
    }

    public FluidCraftingPreviewElement(FluidStack stack, int available, boolean missing, int toCraft) {
        this.stack = stack.copy();
        this.available = available;
        this.missing = missing;
        this.toCraft = toCraft;
    }

    public static FluidCraftingPreviewElement read(FriendlyByteBuf buf) {
        FluidStack stack = FluidStack.readFromPacket((FriendlyByteBuf)buf);
        int available = buf.readInt();
        boolean missing = buf.readBoolean();
        int toCraft = buf.readInt();
        return new FluidCraftingPreviewElement(stack, available, missing, toCraft);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        this.stack.writeToPacket(buf);
        buf.writeInt(this.available);
        buf.writeBoolean(this.missing);
        buf.writeInt(this.toCraft);
    }

    public FluidStack getStack() {
        return this.stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack poseStack, int x, int y, IElementDrawers drawers) {
        if (this.missing) {
            drawers.getOverlayDrawer().draw(poseStack, x, y, -860450);
        }
        drawers.getFluidDrawer().draw(poseStack, x += 5, y += 7, this.getStack());
        float scale = Minecraft.m_91087_().m_91390_() ? 1.0f : 0.5f;
        y += 2;
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        if (this.toCraft > 0) {
            String format = this.doesDisableTaskStarting() ? "gui.refinedstorage.crafting_preview.missing" : "gui.refinedstorage.crafting_preview.to_craft";
            drawers.getStringDrawer().draw(poseStack, RenderUtils.getOffsetOnScale(x + 23, scale), RenderUtils.getOffsetOnScale(y, scale), I18n.m_118938_((String)format, (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.toCraft)}));
            y += 7;
        }
        if (this.available > 0) {
            drawers.getStringDrawer().draw(poseStack, RenderUtils.getOffsetOnScale(x + 23, scale), RenderUtils.getOffsetOnScale(y, scale), I18n.m_118938_((String)"gui.refinedstorage.crafting_preview.available", (Object[])new Object[]{API.instance().getQuantityFormatter().formatInBucketForm(this.available)}));
        }
        poseStack.m_85849_();
    }

    public void addAvailable(int amount) {
        this.available += amount;
    }

    public void addToCraft(int amount) {
        this.toCraft += amount;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    @Override
    public boolean doesDisableTaskStarting() {
        return this.missing;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

