/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import li.cil.scannable.common.config.CommonConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="scannable", bus=Mod.EventBusSubscriber.Bus.MOD)
public enum IgnoredBlocks {
    INSTANCE;

    private Set<Block> ignoredBlocks;

    public static boolean contains(BlockState state) {
        INSTANCE.validateFilter();
        return IgnoredBlocks.INSTANCE.ignoredBlocks.contains(state.m_60734_());
    }

    private void validateFilter() {
        if (this.ignoredBlocks != null) {
            return;
        }
        HashSet<Block> ignoredBlocks = new HashSet<Block>();
        for (ResourceLocation location : CommonConfig.ignoredBlocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
            if (block == null) continue;
            ignoredBlocks.add(block);
        }
        ArrayList<Tag> ignoredTags = new ArrayList<Tag>();
        for (ResourceLocation location : CommonConfig.ignoredBlockTags) {
            Tag tag2 = BlockTags.m_13115_().m_13404_(location);
            if (tag2 == null) continue;
            ignoredTags.add(tag2);
        }
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            BlockState blockState = block.m_49966_();
            if (!ignoredTags.stream().anyMatch(tag -> tag.m_8110_((Object)block))) continue;
            ignoredBlocks.add(blockState.m_60734_());
        }
        this.ignoredBlocks = ignoredBlocks;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        IgnoredBlocks.INSTANCE.ignoredBlocks = null;
    }
}

