/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import li.cil.scannable.api.scanning.BlockScannerModule;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.client.scanning.ScanResultProviders;
import li.cil.scannable.client.scanning.filter.BlockCacheScanFilter;
import li.cil.scannable.client.scanning.filter.FluidTagScanFilter;
import li.cil.scannable.common.config.CommonConfig;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="scannable", bus=Mod.EventBusSubscriber.Bus.MOD)
public enum FluidBlockScannerModule implements BlockScannerModule
{
    INSTANCE;

    private Predicate<BlockState> filter;

    @Override
    public int getEnergyCost(ItemStack module) {
        return CommonConfig.energyCostModuleFluid;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)ScanResultProviders.BLOCKS.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float adjustLocalRange(float range) {
        return range * 0.5f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<BlockState> getFilter(ItemStack module) {
        this.validateFilter();
        return this.filter;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void validateFilter() {
        if (this.filter != null) {
            return;
        }
        ArrayList<Predicate<BlockState>> filters = new ArrayList<Predicate<BlockState>>();
        for (Tag tag : FluidTags.m_144300_()) {
            Tag.Named namedTag;
            if (!(tag instanceof Tag.Named) || CommonConfig.ignoredFluidTags.contains((namedTag = (Tag.Named)tag).m_6979_())) continue;
            filters.add(new FluidTagScanFilter((Tag<Fluid>)tag));
        }
        this.filter = new BlockCacheScanFilter((Collection<Predicate<BlockState>>)filters);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        FluidBlockScannerModule.INSTANCE.filter = null;
    }
}

