/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import li.cil.scannable.api.scanning.BlockScannerModule;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.client.scanning.ScanResultProviders;
import li.cil.scannable.client.scanning.filter.BlockCacheScanFilter;
import li.cil.scannable.client.scanning.filter.BlockScanFilter;
import li.cil.scannable.client.scanning.filter.BlockTagScanFilter;
import li.cil.scannable.common.config.CommonConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="scannable", bus=Mod.EventBusSubscriber.Bus.MOD)
public enum CommonOresBlockScannerModule implements BlockScannerModule
{
    INSTANCE;

    private Predicate<BlockState> filter;

    @Override
    public int getEnergyCost(ItemStack module) {
        return CommonConfig.energyCostModuleOreCommon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)ScanResultProviders.BLOCKS.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float adjustLocalRange(float range) {
        return range * 0.25f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<BlockState> getFilter(ItemStack module) {
        this.validateFilter();
        return this.filter;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void validateFilter() {
        if (this.filter != null) {
            return;
        }
        ArrayList<Predicate<BlockState>> filters = new ArrayList<Predicate<BlockState>>();
        for (ResourceLocation location : CommonConfig.commonOreBlocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
            if (block == null) continue;
            filters.add(new BlockScanFilter(block));
        }
        for (ResourceLocation location : CommonConfig.commonOreBlockTags) {
            Tag tag = BlockTags.m_13115_().m_13404_(location);
            if (tag == null) continue;
            filters.add(new BlockTagScanFilter((Tag<Block>)tag));
        }
        this.filter = new BlockCacheScanFilter((Collection<Predicate<BlockState>>)filters);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        CommonOresBlockScannerModule.INSTANCE.filter = null;
    }
}

