/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.network.message;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public abstract class AbstractMessage {
    protected AbstractMessage() {
    }

    protected AbstractMessage(FriendlyByteBuf buffer) {
        this.fromBytes(buffer);
    }

    public static boolean handleMessage(AbstractMessage message, Supplier<NetworkEvent.Context> contextSupplied) {
        NetworkEvent.Context context = contextSupplied.get();
        context.enqueueWork(() -> message.handleMessage(context));
        return true;
    }

    protected abstract void handleMessage(NetworkEvent.Context var1);

    public abstract void fromBytes(FriendlyByteBuf var1);

    public abstract void toBytes(FriendlyByteBuf var1);

    @Nullable
    protected Level getServerLevel(NetworkEvent.Context context) {
        ServerPlayer sender = context.getSender();
        return sender != null ? sender.m_183503_() : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }
}

