/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.container.EntityModuleContainerMenu;
import li.cil.scannable.common.item.ScannerModuleItem;
import li.cil.scannable.common.scanning.ConfigurableEntityScannerModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public final class ConfigurableEntityScannerModuleItem
extends ScannerModuleItem {
    private static final String TAG_ENTITY_DEPRECATED = "entity";
    private static final String TAG_ENTITIES = "entities";
    private static final String TAG_IS_LOCKED = "isLocked";

    public static boolean isLocked(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(TAG_IS_LOCKED);
    }

    public static List<EntityType<?>> getEntityTypes(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_(TAG_ENTITY_DEPRECATED, 8) && !tag.m_128425_(TAG_ENTITIES, 9)) {
            return Collections.emptyList();
        }
        ConfigurableEntityScannerModuleItem.upgradeData(tag);
        ListTag list = tag.m_128437_(TAG_ENTITIES, 8);
        ArrayList result = new ArrayList();
        list.forEach(item -> {
            Optional entityType = EntityType.m_20632_((String)item.m_7916_());
            entityType.ifPresent(result::add);
        });
        return result;
    }

    private static boolean addEntityType(ItemStack stack, EntityType<?> entityType) {
        ResourceLocation registryName = entityType.getRegistryName();
        if (registryName == null) {
            return false;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_LOCKED)) {
            return false;
        }
        StringTag itemNbt = StringTag.m_129297_((String)registryName.toString());
        ListTag list = tag.m_128437_(TAG_ENTITIES, 8);
        if (list.contains((Object)itemNbt)) {
            return true;
        }
        if (list.size() >= 5) {
            return false;
        }
        tag.m_128365_(TAG_ENTITIES, (Tag)list);
        list.add((Object)itemNbt);
        return true;
    }

    public static void setEntityTypeAt(ItemStack stack, int index, EntityType<?> entityType) {
        if (index < 0 || index >= 5) {
            return;
        }
        ResourceLocation registryName = entityType.getRegistryName();
        if (registryName == null) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_LOCKED)) {
            return;
        }
        StringTag itemNbt = StringTag.m_129297_((String)registryName.toString());
        ListTag list = tag.m_128437_(TAG_ENTITIES, 8);
        int oldIndex = list.indexOf((Object)itemNbt);
        if (oldIndex == index) {
            return;
        }
        if (index >= list.size()) {
            list.add((Object)itemNbt);
        } else {
            list.set(index, (Tag)itemNbt);
        }
        if (oldIndex >= 0) {
            list.remove(oldIndex);
        }
        tag.m_128365_(TAG_ENTITIES, (Tag)list);
    }

    public static void removeEntityTypeAt(ItemStack stack, int index) {
        if (index < 0 || index >= 5) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(TAG_IS_LOCKED)) {
            return;
        }
        ListTag list = tag.m_128437_(TAG_ENTITIES, 8);
        if (index < list.size()) {
            list.remove(index);
        }
    }

    private static void upgradeData(CompoundTag tag) {
        if (tag.m_128425_(TAG_ENTITY_DEPRECATED, 8)) {
            ListTag list = new ListTag();
            list.add((Object)tag.m_128423_(TAG_ENTITY_DEPRECATED));
            tag.m_128365_(TAG_ENTITIES, (Tag)list);
            tag.m_128473_(TAG_ENTITY_DEPRECATED);
        }
    }

    public ConfigurableEntityScannerModuleItem() {
        super(ConfigurableEntityScannerModule.INSTANCE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        List<EntityType<?>> entities = ConfigurableEntityScannerModuleItem.getEntityTypes(stack);
        if (!entities.isEmpty()) {
            tooltip.add(Strings.TOOLTIP_ENTITIES_LIST_CAPTION);
            entities.forEach(e -> tooltip.add(Strings.listItem(e.m_20676_())));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, final InteractionHand hand) {
        final ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return stack.m_41786_();
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    return new EntityModuleContainerMenu(id, inventory, hand);
                }
            }, buffer -> buffer.m_130068_((Enum)hand));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (ConfigurableEntityScannerModuleItem.addEntityType(player.m_21120_(hand), target.m_6095_())) {
            player.m_6674_(hand);
            player.m_150109_().m_6596_();
        } else if (!player.f_19853_.m_5776_() && !ConfigurableEntityScannerModuleItem.isLocked(stack)) {
            player.m_5661_(Strings.MESSAGE_NO_FREE_SLOTS, true);
        }
        return InteractionResult.m_19078_((boolean)player.f_19853_.m_5776_());
    }
}

